<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:jmx="http://xml.kishou.go.jp/jmaxml1/"
xmlns:h="http://xml.kishou.go.jp/jmaxml1/informationBasis1/"
xmlns:m="http://xml.kishou.go.jp/jmaxml1/body/meteorology1/"
exclude-result-prefixes="xsl jmx h m">

  <xsl:import href='s0-ymdhn.xsl' />

  <xsl:output method="html" encoding="UTF-8"/>

  <xsl:param name="files" />

  <!-- for test -->
  <xsl:template match="/">
    <html>
    <head>
    <title>message list</title>
    </head>
    <body>
    <h1>message list</h1>
    <table>
    <xsl:apply-templates select="jmx:Report" />
    <xsl:call-template name="chain">
      <xsl:with-param name="files" select="normalize-space($files)" />
    </xsl:call-template>
    </table>
    </body>
    </html>
  </xsl:template>

  <xsl:template name="chain">
    <xsl:param name="files" />
    <xsl:variable name="first">
      <xsl:choose>
      <xsl:when test="contains($files, ' ')">
        <xsl:value-of select="substring-before($files, ' ')" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$files" />
      </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="rest">
      <xsl:choose>
      <xsl:when test="contains($files, ' ')">
        <xsl:value-of select="substring-after($files, ' ')" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="''" />
      </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:if test="$first != ''">
      <xsl:apply-templates select="document($first)/jmx:Report">
        <xsl:with-param name="filename" select="$first"/>
      </xsl:apply-templates>
    </xsl:if>
    <xsl:if test="$rest != ''">
      <xsl:call-template name="chain">
        <xsl:with-param name="files" select="$rest" />
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template match="jmx:Report">
  <xsl:param name="filename" select="''"/>
  <tr>
  <td>
    <xsl:value-of select="$filename" />
  </td>
  <td>
    <xsl:value-of select="jmx:Control/jmx:Title" />
  </td>
  <td>
    <xsl:call-template name="nengappijihun">
    <xsl:with-param name="t" select="h:Head/h:ReportDateTime" />
    </xsl:call-template>
  </td>
  <td>
    <xsl:call-template name="nengappijihun">
    <xsl:with-param name="t" select="h:Head/h:TargetDateTime" />
    </xsl:call-template>
  </td>
  <td>
    <xsl:value-of select="jmx:Control/jmx:EditorialOffice" />
  </td>
  </tr>
  </xsl:template>

</xsl:stylesheet>
