<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:jmx="http://xml.kishou.go.jp/jmaxml1/"
xmlns:h="http://xml.kishou.go.jp/jmaxml1/informationBasis1/"
xmlns:m="http://xml.kishou.go.jp/jmaxml1/body/meteorology1/"
exclude-result-prefixes="xsl jmx h m">
  <!-- 注意報・警報電文から市町村等別発表状況の表（HTML）を作る例 -->
  <xsl:output method="html" encoding="UTF-8"/>
  <xsl:template match="/">
    <!-- 不適切な情報種類の電文を与えた場合メッセージを出して終了する。
    xsltproc ならば異常終了する。
    xsltproc を使う場合このメッセージが標準出力に出てしまうため、
    -o オプションで出力ファイルを指定することを推奨。 -->
    <xsl:if test="/jmx:Report/h:Head/h:InfoKind != '気象警報・注意報'">
      <xsl:message terminate="yes">
        <xsl:value-of
        select="concat('bad InfoKind ', /jmx:Report/h:Head/h:InfoKind)"/>
      </xsl:message>
    </xsl:if>
    
    <html>
      <head>
        <meta charset="utf-8"/>
        <title>
          <!-- 試験電文など非通常であればその旨注記する -->
          <xsl:value-of select="/jmx:Report/h:Head/h:Title"/>
          <xsl:if test="/jmx:Report/jmx:Control/jmx:Status != '通常'">
            <xsl:value-of
            select="concat(' (', /jmx:Report/jmx:Control/jmx:Status, ')')"/>
          </xsl:if>
        </title>
        <!-- CSS スタイルシートで色付けなどができます -->
        <link rel="stylesheet" type="text/css" href="style.css"/>
      </head>
      <body>
        <!-- 本物の気象庁ホームページと間違えないための注記 -->
        <p>テスト用スタイルシート</p>
        <h1>
          <!-- 試験電文など非通常であればその旨注記する -->
          <!-- head/title と共通だが XSLT 変数を説明する前のチュートリアル
          のための例なので敢えて無駄に書いている -->
          <xsl:value-of select="/jmx:Report/h:Head/h:Title"/>
          <xsl:if test="/jmx:Report/jmx:Control/jmx:Status != '通常'">
            <xsl:value-of
            select="concat(' (', /jmx:Report/jmx:Control/jmx:Status, ')')"/>
          </xsl:if>
        </h1>
        <!-- 一意にできるタグには @id, それが無理なものには @class を
        なるべくつけている。あとで CSS でいじるときに追加するのも面倒だし、
        公共サービスとしてスクレイピングが容易になるよう配慮しておくべき。 -->
        <p id="credit">
          <!-- PublishingOffice が責任をもつ官署。
          EditorialOffice はその名と無関係に府県予報区を指示するものなので
          ここでは出番はない -->
          <span id="PublishingOffice">
            <xsl:value-of select="/jmx:Report/jmx:Control/jmx:PublishingOffice"/>
          </span>
          <!-- 訂正報はそのむねカッコ書きすることにした。
          訂正報といえども ReportDateTime に発表と呼ぶべきと考えられる。 -->
          <span id="ReportDateTime">
            <xsl:value-of select="/jmx:Report/h:Head/h:ReportDateTime"/>
          </span>
          <xsl:text> 発表</xsl:text>
          <xsl:if test="/jmx:Report/h:Head/h:InfoType != '発表'">
            <xsl:value-of select="concat(' (', /jmx:Report/h:Head/h:InfoType, ')')"/>
          </xsl:if>
        </p>
        <table id="datatable">
          <tr class="tablehead">
            <th class="area">市町村等</th>
            <th class="warnstate">発表中の注意報・警報</th>
            <th class="remark">付加事項・切り替え予告</th>
          </tr>
          <!-- m:Warning を選択するのに
          m:Warning[@type='気象警報・注意報（市町村等）']
          として選択することも可能だが、 @type の文字列については
          辞書でのコミットがなく、将来変更があるかもしれないので、
          さしあたり安定して動作する方法として m:Warning[last()] を使った.  -->
          <xsl:for-each select="/jmx:Report/m:Body/m:Warning[last()]/m:Item">
            <tr>
              <td class="area" id="area{m:Area/m:Code}">
                <a href="https://www.jma.go.jp/jp/warn/f_{m:Area/m:Code}.html">
                  <xsl:value-of select="m:Area/m:Name"/>
                </a>
              </td>
              <td class="warnstate">
                <xsl:for-each select="m:Kind">
                  <!-- 小技： position() &gt; 1 はリスト文字列化に読点を
                  いれこむテクニック。 -->
                  <xsl:if test="position() &gt; 1">
                    <xsl:text>、</xsl:text>
                  </xsl:if>
                  <xsl:choose>
                    <xsl:when test="m:Name">
                      <span class="kind{m:Code}">
                        <xsl:value-of select="m:Name"/>
                      </span>
                    </xsl:when>
                    <xsl:when test="m:Status = '発表警報・注意報はなし'">
                      <span class="clear">なし</span>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="m:Status"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:for-each>
              </td>
              <td class="remark">
                <xsl:if test="m:Kind/m:Attention">
                  <xsl:text>付加事項：</xsl:text>
                  <xsl:for-each select="m:Kind/m:Attention/m:Note">
                    <xsl:if test="position() &gt; 1">
                      <xsl:text>、</xsl:text>
                    </xsl:if>
                    <!-- タグを開いた直後で xsl:attribute を使うと
                    そのタグに属性をつけることができる。
                    -->
                    <span>
                      <xsl:choose>
                      <xsl:when test="contains(., '警戒')">
                        <xsl:attribute name='class'>wrn</xsl:attribute>
                      </xsl:when>
                      <xsl:when test="contains(., '注意')">
                        <xsl:attribute name='class'>adv</xsl:attribute>
                      </xsl:when>
                      </xsl:choose>
                      <xsl:value-of select="."/>
                    </span>
                  </xsl:for-each>
                  <xsl:text>。</xsl:text>
                </xsl:if>
                <xsl:for-each select="m:Kind/m:WarningNotice">
                  <span>
                    <xsl:choose>
                    <xsl:when test="contains(m:Note, '特別警報')">
                      <xsl:attribute name='class'>emg</xsl:attribute>
                    </xsl:when>
                    <xsl:when test="contains(m:Note, '警報')">
                      <xsl:attribute name='class'>wrn</xsl:attribute>
                    </xsl:when>
                    </xsl:choose>
                    <!-- 「までに」はウェブサイト実例による。 -->
                    <xsl:value-of select="concat(m:StartTime, 'までに', m:Note)" />
                  </span>
                  <xsl:text>。</xsl:text>
                </xsl:for-each>
              </td>
            </tr>
          </xsl:for-each>
        </table>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
