<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
	xmlns:gco="http://www.isotc211.org/2005/gco" xmlns:gmd="http://www.isotc211.org/2005/gmd"
	xmlns:gml="http://www.opengis.net/gml" xmlns:gts="http://www.isotc211.org/2005/gts"
	xmlns:gmi="http://www.isotc211.org/2005/gmi" xmlns:gmx="http://www.isotc211.org/2005/gmx"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xlink="http://www.w3.org/1999/xlink">
	<xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" scope="stylesheet">
		<xd:desc>
			<xd:p><xd:b>Created on:</xd:b> May 4, 2010</xd:p>
			<xd:p><xd:b>Author:</xd:b> ted.habermann@noaa.gov</xd:p>
			<xd:p><xd:b>Updated for WMO:</xd:b> May 15, 2012</xd:p>
			<xd:p><xd:b>Author:</xd:b> john.kozimor@noaa.gov</xd:p>
			<xd:p/>
		</xd:desc>
	</xd:doc>
	<!--<xsl:include href="http://www.ngdc.noaa.gov/metadata/published/xsl/isoRubricStars.xsl"/>-->
	<xsl:template match="/">
		<!-- *************** -->
		<!-- calculation variables; must match variables isoRubricStars.xsl  -->
		<!-- *************** -->
		<xsl:variable name="title"
			select="//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:title/gco:CharacterString"/>
		<xsl:variable name="keywordTypeCodeTheme"
			select="//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='theme']"/>
		<xsl:variable name="wmoCatCodeRef"
			select="//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gmx:Anchor/@xlink:href='http://www.wmo.int/wmo_categoryCodelist'"/>
		<xsl:variable name="wmoCatCodes"
			select="//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:keyword/gco:CharacterString[text()='weatherObservations' or text()='weatherForecasts' or text()='meteorology' or text()='hydrology' or text()='climatology' or text()='landMeteorologyClimate' or text()='synopticMeteorology' or text()='marineMeteorology' or text()='agriculturalMeteorology' or text()='aerology' or text()='marineAerology' or text()='oceanography' or text()='landHydrology' or text()='rocketSounding' or text()='pollution' or text()='waterPollution' or text()='landWaterPollution' or text()='seaPollution' or text()='landPollution' or text()='airPollution' or text()='glaciology' or text()='actinometry' or text()='satelliteObservation' or text()='airplaneObservation' or text()='observationPlatform']"/>
		<!-- ISO Mandatory Core Fields: 7 possible -->
		<xsl:variable name="titleCnt"
			select="count(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:title/gco:CharacterString)"/>
		<xsl:variable name="creationDateCnt"
			select="count(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:date/gmd:CI_Date/gmd:date/gco:Date)"/>
		<xsl:variable name="datasetLanguageCnt"
			select="count(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:language/gmd:LanguageCode)"/>
		<xsl:variable name="topicCategoryCnt"
			select="count(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:topicCategory/gmd:MD_TopicCategoryCode)"/>
		<xsl:variable name="topicCategoryExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:topicCategory/gmd:MD_TopicCategoryCode)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="abstractCnt"
			select="count(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:abstract/gco:CharacterString)"/>
		<xsl:variable name="metadataContactExist">
			<xsl:choose>
				<xsl:when test="(//gmi:MI_Metadata/gmd:contact|gmd:MD_Metadata/gmd:contact)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="metadataContactCnt"
			select="count(gmi:MI_Metadata/gmd:contact|gmd:MD_Metadata/gmd:contact)"/>
		<xsl:variable name="metadataDateStampCnt"
			select="count(gmi:MI_Metadata/gmd:dateStamp|gmd:MD_Metadata/gmd:dateStamp)"/>
		<xsl:variable name="ISOMandatoryTotal"
			select="$titleCnt + $creationDateCnt + $datasetLanguageCnt + $topicCategoryExist + $abstractCnt + $metadataContactCnt + $metadataDateStampCnt"/>
		<xsl:variable name="ISOMandatoryMax">7</xsl:variable>
		<!-- ISO Conditional Core Fields: 4 possible -->
		<xsl:variable name="metadataLanguageCnt"
			select="count(gmi:MI_Metadata/gmd:language|gmd:MD_Metadata/gmd:language)"/>
		<xsl:variable name="metadataCharacterSetCnt"
			select="count(gmi:MI_Metadata/gmd:characterSet|gmd:MD_Metadata/gmd:characterSet)"/>
		<xsl:variable name="datasetCharacterSetCnt"
			select="count(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:characterSet)"/>
		<xsl:variable name="datasetExtentCnt"
			select="count(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent[@id='boundingExtent']/gmd:geographicElement/gmd:EX_GeographicBoundingBox)"/>
		<xsl:variable name="ISOConditionalTotal"
			select="$metadataLanguageCnt + $metadataCharacterSetCnt + $datasetCharacterSetCnt + $datasetExtentCnt"/>
		<xsl:variable name="ISOConditionalMax">4</xsl:variable>
		<!--  -->
		<!-- ISO Optional Core Fields: 12 possible -->
		<xsl:variable name="temporalCnt"
			select="count(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent[@id='boundingExtent']/gmd:temporalElement/gmd:EX_TemporalExtent[@id='boundingTemporalExtent']/gmd:extent)"/>
		<xsl:variable name="verticalCnt"
			select="count(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent[@id='boundingExtent']/gmd:verticalElement/gmd:EX_VerticalExtent[@id='boundingVerticalExtent']/gmd:minimumValue/gco:Real)"/>
		<xsl:variable name="resourceContactExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:pointOfContact/gmd:CI_ResponsibleParty)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="resourceContactCnt"
			select="count(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:pointOfContact/gmd:CI_ResponsibleParty)"/>
		<xsl:variable name="lineageExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:dataQualityInfo/gmd:DQ_DataQuality/gmd:lineage/gmd:LI_Lineage)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="lineageCnt"
			select="count(//gmd:dataQualityInfo/gmd:DQ_DataQuality/gmd:lineage/gmd:LI_Lineage)"/>
		<xsl:variable name="distOnlineResourceExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:distributionInfo//gmd:MD_DigitalTransferOptions/gmd:onLine/gmd:CI_OnlineResource/gmd:linkage/gmd:URL)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="distOnlineResourceCnt"
			select="count(//gmd:distributionInfo//gmd:MD_DigitalTransferOptions/gmd:onLine/gmd:CI_OnlineResource/gmd:linkage/gmd:URL)"/>
		<xsl:variable name="onlineResourceURLExist">
			<xsl:choose>
				<xsl:when test="(//gmd:CI_OnlineResource/gmd:linkage/gmd:URL)">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="onlineResourceURLCnt"
			select="count(//gmd:CI_OnlineResource/gmd:linkage/gmd:URL)"/>
		<xsl:variable name="onlineResourceNameExist">
			<xsl:choose>
				<xsl:when test="(//gmd:CI_OnlineResource/gmd:name/gco:CharacterString)">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="onlineResourceNameCnt"
			select="count(//gmd:CI_OnlineResource/gmd:name/gco:CharacterString)"/>
		<xsl:variable name="allOnlineResourceNamesExist">
			<xsl:choose>
				<xsl:when test="($onlineResourceNameCnt = $onlineResourceURLCnt)">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="onlineResourceDescExist">
			<xsl:choose>
				<xsl:when test="(//gmd:CI_OnlineResource/gmd:description/gco:CharacterString)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="onlineResourceDescCnt"
			select="count(//gmd:CI_OnlineResource/gmd:description/gco:CharacterString)"/>
		<xsl:variable name="allOnlineResourceDescExist">
			<xsl:choose>
				<xsl:when test="($onlineResourceDescCnt = $onlineResourceURLCnt)">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="onlineResourceFunctionExist">
			<xsl:choose>
				<xsl:when test="(//gmd:CI_OnlineResource/gmd:function/gmd:CI_OnLineFunctionCode)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="onlineResourceFunctionCnt"
			select="count(//gmd:CI_OnlineResource/gmd:function/gmd:CI_OnLineFunctionCode)"/>
		<xsl:variable name="allOnlineResourceFunctionExist">
			<xsl:choose>
				<xsl:when test="($onlineResourceFunctionCnt = $onlineResourceURLCnt)">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="idCnt"
			select="count(gmi:MI_Metadata/gmd:fileIdentifier|gmd:MD_Metadata/gmd:fileIdentifier)"/>
		<xsl:variable name="spatialRepresentationTypeCnt"
			select="count(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:spatialRepresentationType)"/>
		<xsl:variable name="distributionFormatExist">
			<xsl:choose>
				<xsl:when test="(//gmd:distributionInfo/gmd:MD_Distribution//gmd:MD_Format)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="distributionFormatCnt"
			select="count(//gmd:distributionInfo//gmd:MD_Format)"/>
		<xsl:variable name="metadataStandardNameCnt"
			select="count(//gmd:metadataStandardName/gco:CharacterString)"/>
		<xsl:variable name="metadataStandardVersionCnt"
			select="count(//gmd:metadataStandardVersion/gco:CharacterString)"/>
		<xsl:variable name="referenceSystemCnt"
			select="count(gmi:MI_Metadata/gmd:referenceSystemInfo|gmd:MD_Metadata/gmd:referenceSystemInfo/gmd:MD_ReferenceSystem)"/>
		<xsl:variable name="spatialResolutionCnt"
			select="count(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:spatialResolution/gmd:MD_Resolution)"/>
		<xsl:variable name="ISOOptionalTotal"
			select="$temporalCnt + $verticalCnt + $resourceContactExist + $lineageExist + $distOnlineResourceExist + $idCnt + $spatialRepresentationTypeCnt  + $distributionFormatExist + $metadataStandardNameCnt + $metadataStandardVersionCnt     + $referenceSystemCnt + $spatialResolutionCnt"/>
		<xsl:variable name="ISOOptionalMax">12</xsl:variable>
		<xsl:variable name="ISOCoreTotal"
			select="$ISOMandatoryTotal + $ISOOptionalTotal + $ISOConditionalTotal"/>
		<xsl:variable name="ISOCoreMax"
			select="$ISOMandatoryMax + $ISOOptionalMax + $ISOConditionalMax"/>
		<!--  -->
		<xsl:variable name="datasetExtentDescriptionCnt"
			select="count(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent[@id='boundingExtent']/gmd:description/gco:CharacterString)"/>
		<!-- Keyword Type Fields -->
		<xsl:variable name="themeKeywordExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='theme'])"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="themeKeywordCnt"
			select="count(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='theme'])"/>
		<xsl:variable name="themeKeywordThesaurusExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='theme']/ancestor::node()/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gco:CharacterString)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="themeKeywordThesaurusCnt"
			select="count(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='theme']/ancestor::node()/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gco:CharacterString)"/>
		<!--  -->
		<xsl:variable name="dataCenterKeywordExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='dataCenter'])"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="dataCenterKeywordCnt"
			select="count(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='dataCenter'])"/>
		<xsl:variable name="dataCenterKeywordThesaurusExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='dataCenter']/ancestor::node()/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gco:CharacterString)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="dataCenterKeywordThesaurusCnt"
			select="count(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='dataCenter']/ancestor::node()/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gco:CharacterString)"/>
		<!--  -->
		<xsl:variable name="projectKeywordExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='project'])"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="projectKeywordCnt"
			select="count(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='project'])"/>
		<xsl:variable name="projectKeywordThesaurusExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='project']/ancestor::node()/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gco:CharacterString)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="projectKeywordThesaurusCnt"
			select="count(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='project']/ancestor::node()/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gco:CharacterString)"/>
		<!--  -->
		<xsl:variable name="placeKeywordExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='place'])"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="placeKeywordCnt"
			select="count(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='place'])"/>
		<xsl:variable name="placeKeywordThesaurusExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='place']/ancestor::node()/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gco:CharacterString)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="placeKeywordThesaurusCnt"
			select="count(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='place']/ancestor::node()/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gco:CharacterString)"/>
		<!--  -->
		<xsl:variable name="instrumentKeywordExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='instrument'])"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="instrumentKeywordCnt"
			select="count(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='instrument'])"/>
		<xsl:variable name="instrumentKeywordThesaurusExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='instrument']/ancestor::node()/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gco:CharacterString)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="instrumentKeywordThesaurusCnt"
			select="count(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='instrument']/ancestor::node()/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gco:CharacterString)"/>
		<!--  -->
		<xsl:variable name="platformKeywordExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='platform'])"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="platformKeywordCnt"
			select="count(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='platform'])"/>
		<xsl:variable name="platformKeywordThesaurusExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='platform']/ancestor::node()/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gco:CharacterString)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="platformKeywordThesaurusCnt"
			select="count(//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='platform']/ancestor::node()/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gco:CharacterString)"/>
		<!-- Identification Spiral Scores -->
		<xsl:variable name="citationDateExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:date/gmd:CI_Date/gmd:date/gco:Date)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Distribution Spiral Scores -->
		<xsl:variable name="distributorContactExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:distributionInfo/gmd:MD_Distribution/gmd:distributor/gmd:MD_Distributor/gmd:distributorContact/gmd:CI_ResponsibleParty)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="distributorContactCnt"
			select="count(//gmd:distributionInfo/gmd:MD_Distribution/gmd:distributor/gmd:MD_Distributor/gmd:distributorContact/gmd:CI_ResponsibleParty)"/>
		<xsl:variable name="graphicOverviewCnt"
			select="count(//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:graphicOverview/gmd:MD_BrowseGraphic/gmd:fileName/gco:CharacterString)"/>
		<!-- Description Scores -->
		<xsl:variable name="purposeCnt"
			select="count(//gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:purpose/gco:CharacterString)"/>
		<xsl:variable name="lineageStatementCnt"
			select="count(//gmd:dataQualityInfo/gmd:DQ_DataQuality/gmd:lineage/gmd:LI_Lineage/gmd:statement/gco:CharacterString)"/>
		<!-- Content Information Scores -->
		<xsl:variable name="contentTypeExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:contentInfo/gmi:MI_CoverageDescription/gmd:contentType/gmd:MD_CoverageContentTypeCode)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="contentTypeCnt"
			select="count(//gmd:contentInfo/gmi:MI_CoverageDescription/gmd:contentType/gmd:MD_CoverageContentTypeCode)"/>
		<xsl:variable name="dimensionNameExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:contentInfo/gmi:MI_CoverageDescription/gmd:dimension/gmd:MD_Band/gmd:sequenceIdentifier/gco:MemberName/gco:aName/gco:CharacterString)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="dimensionNameCnt"
			select="count(//gmd:contentInfo/gmi:MI_CoverageDescription/gmd:dimension/gmd:MD_Band/gmd:sequenceIdentifier/gco:MemberName/gco:aName/gco:CharacterString)"/>
		<xsl:variable name="dimensionDescriptorExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:contentInfo/gmi:MI_CoverageDescription/gmd:dimension/gmd:MD_Band/gmd:descriptor/gco:CharacterString)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="dimensionDescriptorCnt"
			select="count(//gmd:contentInfo/gmi:MI_CoverageDescription/gmd:dimension/gmd:MD_Band/gmd:descriptor/gco:CharacterString)"/>
		<xsl:variable name="dimensionUnitsExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:contentInfo/gmi:MI_CoverageDescription/gmd:dimension/gmd:MD_Band/gmd:units)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="dimensionUnitsCnt"
			select="count(//gmd:contentInfo/gmi:MI_CoverageDescription/gmd:dimension/gmd:MD_Band/gmd:units)"/>
		<!-- Lineage Scores -->
		<xsl:variable name="sourceExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:dataQualityInfo/gmd:DQ_DataQuality/gmd:lineage/gmd:LI_Lineage/gmd:source/gmd:LI_Source)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="sourceCnt"
			select="count(//gmd:dataQualityInfo/gmd:DQ_DataQuality/gmd:lineage/gmd:LI_Lineage/gmd:source/gmd:LI_Source)"/>
		<xsl:variable name="processStepExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:dataQualityInfo/gmd:DQ_DataQuality/gmd:lineage/gmd:LI_Lineage/gmd:processStep/gmd:LI_ProcessStep|      //gmd:dataQualityInfo/gmd:DQ_DataQuality/gmd:lineage/gmd:LI_Lineage/gmd:processStep/gmd:LE_ProcessStep)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="processStepCnt"
			select="count(//gmd:dataQualityInfo/gmd:DQ_DataQuality/gmd:lineage/gmd:LI_Lineage/gmd:processStep/gmd:LI_ProcessStep|    //gmd:dataQualityInfo/gmd:DQ_DataQuality/gmd:lineage/gmd:LI_Lineage/gmd:processStep/gmd:LE_ProcessStep)"/>
		<!-- Acquisition Information Scores -->
		<xsl:variable name="instrumentExist">
			<xsl:choose>
				<xsl:when
					test="(//gmi:MI_Metadata/gmi:acquisitionInformation/gmi:MI_AcquisitionInformation/gmi:instrument/gmi:MI_Instrument)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="instrumentCnt"
			select="count(//gmi:MI_Metadata/gmi:acquisitionInformation/gmi:MI_AcquisitionInformation/gmi:instrument/gmi:MI_Instrument)"/>
		<xsl:variable name="platformExist">
			<xsl:choose>
				<xsl:when
					test="(//gmi:MI_Metadata/gmi:acquisitionInformation/gmi:MI_AcquisitionInformation/gmi:platform/gmi:MI_Platform)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="platformCnt"
			select="count(//gmi:MI_Metadata/gmi:acquisitionInformation/gmi:MI_AcquisitionInformation/gmi:platform/gmi:MI_Platform)"/>
		<!--WMO Profile Scores-->
		<xsl:variable name="fileIdentifierExist">
			<xsl:choose>
				<xsl:when test="(/gmd:MD_Metadata/gmd:fileIdentifier/gco:CharacterString != '')"
					>1</xsl:when>
				<xsl:when test="(/gmi:MI_Metadata/gmd:fileIdentifier/gco:CharacterString != '')"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="hierarchyLevelCnt">
			<xsl:choose>
				<xsl:when
					test="(count(/gmd:MD_Metadata/gmd:hierarchyLevel)=0) or (count(/gmd:MD_Metadata/gmd:hierarchyLevel)=1)"
					>1</xsl:when>
				<xsl:when
					test="(count(/gmi:MI_Metadata/gmd:hierarchyLevel)=0) or (count(/gmi:MI_Metadata/gmd:hierarchyLevel)=1)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="hierarchyLevelNameCnt">
			<xsl:choose>
				<xsl:when
					test="(count(/gmd:MD_Metadata/gmd:hierarchyLevelName)=0) or (count(/gmd:MD_Metadata/gmd:hierarchyLevelName)=1)"
					>1</xsl:when>
				<xsl:when
					test="(count(/gmi:MI_Metadata/gmd:hierarchyLevelName)=0) or (count(/gmi:MI_Metadata/gmd:hierarchyLevelName)=1)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="wmoKeywordCheck">
			<xsl:choose>
				<xsl:when test="($wmoCatCodeRef) and ($keywordTypeCodeTheme) and ($wmoCatCodes)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
			
		</xsl:variable>
		<xsl:variable name="topicCategoryExist1">
			<xsl:choose>
				<xsl:when
					test="(/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:topicCategory/gmd:MD_TopicCategoryCode !='')"
					>1</xsl:when>
				<xsl:when
					test="(/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:topicCategory/gmd:MD_TopicCategoryCode !='')"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="boundingExtentsExist">
			<xsl:choose>
				<xsl:when
					test="(//gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/gmd:westBoundLongitude/gco:Decimal != '')
						and (//gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/gmd:eastBoundLongitude/gco:Decimal != '')
						and (//gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/gmd:northBoundLatitude/gco:Decimal != '')
						and (//gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/gmd:southBoundLatitude/gco:Decimal != '')"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="WMOProfileTotal"
			select="$fileIdentifierExist + $hierarchyLevelCnt + $hierarchyLevelNameCnt + $topicCategoryExist1 + $boundingExtentsExist + $wmoKeywordCheck"/>
		<xsl:variable name="WMOProfileMax">6</xsl:variable>
		<!--INSPIRE Profile Scores-->
		<xsl:variable name="resourceUseLimitationExist">
			<xsl:choose>
				<xsl:when
					test="(/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:resourceConstraints/gmd:MD_Constraints/gmd:useLimitation/gco:CharacterString !='')"
					>1</xsl:when>
				<xsl:when
					test="(/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:resourceConstraints/gmd:MD_Constraints/gmd:useLimitation/gco:CharacterString !='')"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="qualityReportExist">
			<xsl:choose>
				<xsl:when
					test="(/gmd:MD_Metadata/gmd:dataQualityInfo/gmd:DQ_DataQuality/gmd:report)"
					>1</xsl:when>
				<xsl:when
					test="(/gmi:MI_Metadata/gmd:dataQualityInfo/gmd:DQ_DataQuality/gmd:report)"
					>1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="InspireComplianceTotal"
			select="$resourceUseLimitationExist + $qualityReportExist"/>
		<xsl:variable name="InspireComplianceTotalMax">2</xsl:variable>
		<!-- Spiral Scores -->
		<xsl:variable name="identificationTotal"
			select="$idCnt + $titleCnt  + $abstractCnt + $citationDateExist + $topicCategoryExist + $themeKeywordExist + $themeKeywordThesaurusExist + $metadataContactExist + $resourceContactExist"/>
		<xsl:variable name="identificationMax">9</xsl:variable>
		<xsl:variable name="identificationColumn">
			<xsl:choose>
				<xsl:when test="$identificationTotal=0">0</xsl:when>
				<xsl:when test="$identificationTotal=$identificationMax">4</xsl:when>
				<xsl:otherwise>
					<xsl:value-of
						select="floor(number(number($identificationTotal) * 3 div number($identificationMax)))"
					/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="extentTotal"
			select="$datasetExtentCnt + $temporalCnt  + $verticalCnt + $placeKeywordExist + $placeKeywordThesaurusExist"/>
		<xsl:variable name="extentMax">5</xsl:variable>
		<xsl:variable name="connectionTotal"
			select="$onlineResourceURLExist + $allOnlineResourceNamesExist + $allOnlineResourceDescExist + $allOnlineResourceFunctionExist"/>
		<xsl:variable name="connectionMax">4</xsl:variable>
		<xsl:variable name="distributionTotal"
			select="$distributorContactExist + $distributionFormatExist + $distOnlineResourceExist + $graphicOverviewCnt + $dataCenterKeywordExist + $dataCenterKeywordThesaurusExist"/>
		<xsl:variable name="distributionMax">6</xsl:variable>
		<xsl:variable name="contentTotal"
			select="$contentTypeExist + $dimensionDescriptorExist + $dimensionNameExist + $dimensionUnitsExist"/>
		<xsl:variable name="contentMax">4</xsl:variable>
		<xsl:variable name="descriptionTotal"
			select="$datasetExtentDescriptionCnt + $purposeCnt + $lineageStatementCnt + $projectKeywordExist + $projectKeywordThesaurusExist"/>
		<xsl:variable name="descriptionMax">5</xsl:variable>
		<xsl:variable name="lineageTotal" select="$sourceExist + $processStepExist"/>
		<xsl:variable name="lineageMax">2</xsl:variable>
		<xsl:variable name="acquisitionTotal"
			select="$instrumentExist + $platformExist + $instrumentKeywordExist + $instrumentKeywordThesaurusExist + $platformKeywordExist + $platformKeywordThesaurusExist"/>
		<xsl:variable name="acquisitionMax">6</xsl:variable>
		<xsl:variable name="spiralTotal"
			select="$identificationTotal + $extentTotal + $connectionTotal + $distributionTotal + $descriptionTotal + $lineageTotal + $acquisitionTotal + $contentTotal"/>
		<xsl:variable name="spiralMax"
			select="$identificationMax + $extentMax + $connectionMax + $distributionMax + $descriptionMax"/>
		<!-- *************** -->
		<html>
			<head>
				<style type="text/css">
					.sprite {
					    display: -moz-inline-box;
					    display: inline-block;
					    margin: 0;
					    padding: 0;
					    overflow: hidden;
					    vertical-align: middle;
					background: url(http://g-ecx.images-amazon.com/images/G/01/common/sprites/sprite-site-wide-2._V234302190_.png)
					    no-repeat;
					}
					.star_0_0 {
					    background-position: -95px 0px;
					    width: 52px;
					    height: 13px;
					}
					.star_0_5 {
					    background-position: -82px -20px;
					    width: 52px;
					    height: 13px;
					}
					.star_1_0 {
					    background-position: -82px 0px;
					    width: 52px;
					    height: 13px;
					}
					.star_1_5 {
					    background-position: -69px -20px;
					    width: 52px;
					    height: 13px;
					}
					.star_2_0 {
					    background-position: -69px 0px;
					    width: 52px;
					    height: 13px;
					}
					.star_2_5 {
					    background-position: -56px -20px;
					    width: 52px;
					    height: 13px;
					}
					.star_3_0 {
					    background-position: -56px 0px;
					    width: 52px;
					    height: 13px;
					}
					.star_3_5 {
					    background-position: -43px -20px;
					    width: 52px;
					    height: 13px;
					}
					.star_4_0 {
					    background-position: -43px 0px;
					    width: 52px;
					    height: 13px;
					}
					.star_4_5 {
					    background-position: -30px -20px;
					    width: 52px;
					    height: 13px;
					}
					.star_5_0 {
					    background-position: -30px 0px;
					    width: 52px;
					    height: 13px;
					}</style>
			</head>
			<body>
				<h1>ISO 19115 Report for WMO</h1>
				<p>The <a href="https://geo-ide.noaa.gov/wiki/index.php?title=WMO_Metadata_Validation#WMO_Rubric" >WMO Rubric</a> 
					report identifies ISO metadata elements recommended for creating discovery type metadata.  
					The elements defined in this report are not based upon the WMO recommendations for discovery type metadata 
					established by the TT-ApMD expert panel. This report will be updated to match the TT-ApMD recommendations when 
					they become available.  The goal of this report is to assist WMO metadata authors with creating and improving metadata 
					documentation.  The rubric provides authors with feedback regarding the inclusion of required and recommended elements 
					helpful to creating good discovery type metadata. In the future WMO may include rubrics categories for additional metadata types, 
					such as data quality and station history.</p>
					
					<p>The discovery type metadata spirals included in this report are described in <a
						href="https://geo-ide.noaa.gov/wiki/index.php?title=Creating_Good_Documentation"
						>Creating Good Documentation</a>. Together these spirals build a strong
					foundation for high-quality documentation. The ISO Standard includes a number of
					options for building on that foundation by addressing specific scientific needs.
					See <a
						href="https://geo-ide.noaa.gov/wiki/index.php?title=Use_Cases_to_CRUD"
						>Use Cases to CRUD</a> for some examples. </p>
				<p>The elements are listed by name and are followed by M, C, or O if they are
					Mandatory, Conditional or Optional. They are followed by UDD (attribute name) if
					they are included in the <a
						href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
						>NetCDF Attribute Convention for Dataset Discovery</a>.</p>
				<p>The ISO 19115 Standard recommends <a
						href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
						>Core Elements</a> for inclusion in metadata. This tool tests also
					conformance with those recommendations.</p>
				<p>The Rubric at the top of the report summarizes the results. Each spiral is
					represented by a row in the rubric. The columns show the % of the elements in
					that spiral that exist in the record. Click the spiral name for more
					details.</p>
				<p>This report is produced using this <a
						href="http://www.ngdc.noaa.gov/metadata/published/xsl/wmoRubricReport.xsl"
						>stylesheet</a>. Please contact <a href="mailto:ted.habermann@noaa.gov">Ted
						Habermann</a> if you have questions or suggestions.</p>
				<h2> Title: <xsl:value-of select="$title"/></h2>
				<a name="Total Spiral"/>
				<h2>WMO Profile Score: <xsl:value-of select="$WMOProfileTotal"/>/<xsl:value-of
					select="$WMOProfileMax"/></h2>
				<table width="95%" border="1" cellpadding="2" cellspacing="2">
					<tr>
						<th>Spiral</th>
						<th>None</th>
						<th>1-33%</th>
						<th>34-66%</th>
						<th>67-99%</th>
						<th>All</th>
					</tr>
					<xsl:call-template name="showColumn">
						<xsl:with-param name="name" select="'WMO Profile'"/>
						<xsl:with-param name="total" select="$WMOProfileTotal"/>
						<xsl:with-param name="max" select="$WMOProfileMax"/>
					</xsl:call-template>
					<!--<xsl:call-template name="showColumn">
						<xsl:with-param name="name" select="'INSPIRE Profile'"/>
						<xsl:with-param name="total" select="$InspireComplianceTotal"/>
						<xsl:with-param name="max" select="$InspireComplianceTotalMax"/>
						</xsl:call-template>-->
				</table>
				<h2>Discovery Type Metadata Score: <xsl:value-of select="$spiralTotal"/>/<xsl:value-of
						select="$spiralMax"/></h2>
				<style type="text/css">
					table {
					    empty-cells: show;
					}</style>
				<table width="95%" border="1" cellpadding="2" cellspacing="2">
					<tr>
						<th>Spiral</th>
						<th>None <span class="sprite star_0_0"/></th>
						<th>1-33% <span class="sprite star_1_0"/></th>
						<th>34-66% <span class="sprite star_2_0"/></th>
						<th>67-99% <span class="sprite star_3_0"/></th>
						<th>All <span class="sprite star_4_0"/></th>
					</tr>
					<xsl:call-template name="showColumn">
						<xsl:with-param name="name" select="'Total Spiral'"/>
						<xsl:with-param name="total" select="$spiralTotal"/>
						<xsl:with-param name="max" select="$spiralMax"/>
					</xsl:call-template>
					<xsl:call-template name="showColumn">
						<xsl:with-param name="name" select="'Identification'"/>
						<xsl:with-param name="total" select="$identificationTotal"/>
						<xsl:with-param name="max" select="$identificationMax"/>
					</xsl:call-template>
					<xsl:call-template name="showColumn">
						<xsl:with-param name="name" select="'Extent'"/>
						<xsl:with-param name="total" select="$extentTotal"/>
						<xsl:with-param name="max" select="$extentMax"/>
					</xsl:call-template>
					<xsl:call-template name="showColumn">
						<xsl:with-param name="name" select="'Connection'"/>
						<xsl:with-param name="total"
							select="number($onlineResourceNameCnt) + number($onlineResourceDescCnt)"/>
						<xsl:with-param name="max" select="number($onlineResourceURLCnt) * 2"/>
					</xsl:call-template>
					<xsl:call-template name="showColumn">
						<xsl:with-param name="name" select="'Distribution'"/>
						<xsl:with-param name="total" select="$distributionTotal"/>
						<xsl:with-param name="max" select="$distributionMax"/>
					</xsl:call-template>
					<xsl:call-template name="showColumn">
						<xsl:with-param name="name" select="'Description'"/>
						<xsl:with-param name="total" select="$descriptionTotal"/>
						<xsl:with-param name="max" select="$descriptionMax"/>
					</xsl:call-template>
				</table>
				<h2>ISO Core Score: <xsl:value-of select="$ISOCoreTotal"/>/<xsl:value-of
						select="$ISOCoreMax"/></h2>
				<table width="95%" border="1" cellpadding="2" cellspacing="2">
					<tr>
						<th>Spiral</th>
						<th>None</th>
						<th>1-33%</th>
						<th>34-66%</th>
						<th>67-99%</th>
						<th>All</th>
					</tr>
					<xsl:call-template name="showColumn">
						<xsl:with-param name="name" select="'Total Core Score'"/>
						<xsl:with-param name="total" select="$ISOCoreTotal"/>
						<xsl:with-param name="max" select="$ISOCoreMax"/>
					</xsl:call-template>
					<xsl:call-template name="showColumn">
						<xsl:with-param name="name" select="'ISO Core Mandatory'"/>
						<xsl:with-param name="total" select="$ISOMandatoryTotal"/>
						<xsl:with-param name="max" select="$ISOMandatoryMax"/>
					</xsl:call-template>
					<xsl:call-template name="showColumn">
						<xsl:with-param name="name" select="'ISO Core Conditional'"/>
						<xsl:with-param name="total" select="$ISOConditionalTotal"/>
						<xsl:with-param name="max" select="$ISOConditionalMax"/>
					</xsl:call-template>
					<xsl:call-template name="showColumn">
						<xsl:with-param name="name" select="'ISO Core Optional'"/>
						<xsl:with-param name="total" select="$ISOOptionalTotal"/>
						<xsl:with-param name="max" select="$ISOOptionalMax"/>
					</xsl:call-template>
				</table>
				<a href="#Identification">Identification</a> | <a href="#Extent">Extent</a> | <a
				href="#Connection">Connection</a> | <a href="#Distribution">Distribution</a> |
				<a href="#Description">Description</a>
				
				<a name="Identification"/>
				<h2>Identification Score: <xsl:value-of select="$identificationTotal"
						/>/<xsl:value-of select="$identificationMax"/></h2>
				<table width="95%" border="1" cellpadding="2" cellspacing="2">
					<tr>
						<th valign="top">Score</th>
						<th valign="top">Attribute (Count)</th>
						<th valign="top">Description</th>
						<th valign="top">Best Practice</th>
						<th valign="top">Path</th>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$idCnt"/>
						</xsl:call-template>
						<td valign="top">Metadata Identifier<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>O</a>, <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (id)</a></td>
						<td colspan="1" valign="top">A unique phrase or string which uniquely
							identifies the metadata file.</td>
						<td colspan="1" valign="top">Each metadata record shall have a unique
							identifier, such as a universal unique identifier (<a
								href="http://en.wikipedia.org/wiki/Universally_Unique_Identifier"
								>UUID</a>), to distinguish it from other resources. At present these
							identifiers are simple character strings. In order to help ensure
							uniqueness they should include a namespace and a code guaranteed to be
							unique in that namespace. For example: &lt;gmd:fileIdentifier&gt;
							&lt;gco:CharacterString&gt;gov.noaa.class:AERO100&lt;/gco:CharacterString&gt;
							&lt;/gmd:fileIdentifier&gt;. In this case gov.noaa.class is a namespace
							and AERO100 is a code guaranteed to be unique in that namespace. It
							seems likely that the upcoming revision of ISO 19115 will support
							MD_Identifiers as metadata identifiers. <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_Identifiers"
								>More...</a></td>
						<td colspan="1" valign="top">/gmi:MI_Metadata/gmd:fileidentifier</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$titleCnt"/>
						</xsl:call-template>
						<td valign="top">Resource Title<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>M</a>, <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (title)</a></td>
						<td colspan="1" valign="top">Name by which the dataset or resource is
							known</td>
						<td valign="top">
							<a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Identification_Information"
								>More...</a>
						</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:title/gco:CharacterString</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$citationDateExist"/>
						</xsl:call-template>
						<td valign="top">Resource Date<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>M</a>, <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (title)</a></td>
						<td colspan="1" valign="top">Date associated with the resource
							(publication/creation/revision).</td>
						<td valign="top">Whenever possible, include both creation date and revision
							date. <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_Dates"
								>More...</a></td>
						<td colspan="1" valign="top"
							>//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:date/gmd:CI_Date/gmd:date/gco:Date</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$abstractCnt"/>
						</xsl:call-template>
						<td valign="top">Abstract<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>M</a>, <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (summary)</a></td>
						<td colspan="1" valign="top">Brief narrative summary of the resource
							contents.</td>
						<td colspan="1" valign="top">Abstract narrative should include information
							on general content and features; dataset application: GIS, CAD, image,
							database; geographic coverage: county/city name; time period of content:
							begin and end date or single date; and special data characteristics or
							limitations. Note: Many applications limit preliminary display to the
							first 150-200 characters of this field so critical distinguishing
							characteristics should be listed first. <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Identification_Information"
								>More...</a></td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:abstract/gco:CharacterString</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$topicCategoryExist"/>
						</xsl:call-template>
						<td valign="top">Topic Category (<xsl:value-of select="$topicCategoryCnt"
								/>)<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>M</a>, <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (keywords)</a></td>
						<td colspan="1" valign="top">The main theme(s) of the dataset.</td>
						<td colspan="1" valign="top">Select topicCategory from MD_TopicCategoryCode.
							Usually climatologyMeteorologyAtmosphere and/or oceans (keep this
							capitalization and spacing).</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:topicCategory/gmd:MD_TopicCategoryCode</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$themeKeywordExist"/>
						</xsl:call-template>
						<td valign="top">Theme Keywords (<xsl:value-of select="$themeKeywordCnt"
								/>)<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>M</a>, <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (keywords)</a></td>
						<td colspan="1" valign="top">Keywords that describe the general theme of the
							resource.</td>
						<td valign="top" rowspan="2">The <a
								href="http://gcmd.nasa.gov/Resources/valids/">NASA Global Change
								Master Directory</a> and the <a
								href="http://cf-pcmdi.llnl.gov/documents/cf-standard-names/"
								>Climate-Forecast Standard Names</a> are good choices for keyword
							thesaurus</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='theme']</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$themeKeywordThesaurusExist"/>
						</xsl:call-template>
						<td valign="top">Theme Keyword Thesaurus (<xsl:value-of
								select="$themeKeywordCnt"/>)<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (keywords_vocabulary)</a></td>
						<td colspan="1" valign="top">The name of a registered authoritative keyword
							resource.</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='theme']/ancestor::node()/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gco:CharacterString</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$metadataContactCnt"/>
						</xsl:call-template>
						<td valign="top">Metadata Contact<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>M</a>, <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (creator_name, URL, email)</a></td>
						<td colspan="1" valign="top">The responsible party for the metadata
							content.</td>
						<td colspan="1" valign="top">The person/organization directly responsible
							for metadata creation and maintenance.</td>
						<td colspan="1" valign="top">/gmi:MI_Metadata/gmd:contact</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$resourceContactExist"/>
						</xsl:call-template>
						<td valign="top">Resource Contact (<xsl:value-of
								select="$resourceContactCnt"/>)<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>O</a>, <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (creator_name, URL, email)</a></td>
						<td colspan="1" valign="top">Identification and means to contact
							people/organizations associated with the resource.</td>
						<td colspan="1" valign="top">The person/organization directly responsible
							for answering questions about a resource. This could be a person at an
							archive rather than the originator of the resource (described in the
							citation).</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:pointOfContact/gmd:CI_ResponsibleParty)</td>
					</tr>
				</table>
				<a href="#Identification">Identification</a> | <a href="#Extent">Extent</a> | <a
href="#Connection">Connection</a> | <a href="#Distribution">Distribution</a> |
<a href="#Description">Description</a>
				<a name="Extent"/>
				<h2>Extent Score: <xsl:value-of select="$extentTotal"/>/<xsl:value-of
						select="$extentMax"/></h2>
				<table width="95%" border="1" cellpadding="2" cellspacing="2">
					<tr>
						<th valign="top">Score</th>
						<th valign="top">Attribute (Count)</th>
						<th valign="top">Description</th>
						<th valign="top">Best Practice</th>
						<th valign="top">Path</th>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$datasetExtentCnt"/>
						</xsl:call-template>
						<td valign="top">Resource Spatial Extent<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>C</a>, <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (geospatial_lat_min max, geospatial_lon_min max)</a></td>
						<td colspan="1" valign="top">Describes the spatial, horizontal and/or
							vertical, and the temporal coverage in the resource.</td>
						<td colspan="1" valign="top">The bounding extent for the resource should be
							identified with id="boundingExtent": &lt;gmd:EX_Extent
							id="boundingExtent"&gt; <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_Extents"
								> More...</a></td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent[@id='boundingExtent']/gmd:geographicElement']</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$temporalCnt"/>
						</xsl:call-template>
						<td valign="top">Temporal Extent<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (time_coverage_start end)</a></td>
						<td colspan="1" valign="top">Describes the temporal coverage in the
							resource.</td>
						<td colspan="1" valign="top">A temporal element could be used to describe
							either the time period covered by the content of the dataset (e.g.
							during the Jurassic) or the date and time when the data has been
							collected (e.g. the date on which the geological study was completed).
							If both are needed, then two temporal extents should be provided. The
							use of multiple temporal extents should be explained in the attribute
							description of the extent. The bounding extent for the resource should
							be identified with id="boundingExtent": &lt;gmd:EX_Extent
							id="boundingExtent"&gt; <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_Extents"
								>More...</a></td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent[@id='boundingExtent']/gmd:temporalElement/gmd:EX_TemporalExtent/gmd:extent</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$verticalCnt"/>
						</xsl:call-template>
						<td valign="top">Vertical Extent</td>
						<td colspan="1" valign="top">The elements which give the minimum and maximum
							of the vertical extent of the dataset.</td>
						<td colspan="1" valign="top">The bounding extent for the resource should be
							identified with id="boundingExtent": &lt;gmd:EX_Extent
							id="boundingExtent"&gt; <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_Extents"
								>More...</a></td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent[@id='boundingExtent']/gmd:verticalElement/gmd:EX_VerticalExtent</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$placeKeywordExist"/>
						</xsl:call-template>
						<td valign="top">Place Keywords (<xsl:value-of select="$placeKeywordCnt"
								/>)<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (keywords)</a></td>
						<td colspan="1" valign="top">Keywords that describe the location of the
							resource.</td>
						<td valign="top" rowspan="2">The <a
								href="http://gcmd.nasa.gov/Resources/valids/">NASA Global Change
								Master Directory</a> is a good choice for keyword thesaurus</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='theme']</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$placeKeywordThesaurusExist"/>
						</xsl:call-template>
						<td valign="top">Place Keyword Thesaurus (<xsl:value-of
								select="$placeKeywordCnt"/>)<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (keywords_vocabulary)</a></td>
						<td colspan="1" valign="top">The name of a registered authoritative keyword
							resource.</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='theme']/ancestor::node()/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gco:CharacterString</td>
					</tr>
				</table>
				<a href="#Identification">Identification</a> | <a href="#Extent">Extent</a> | <a
href="#Connection">Connection</a> | <a href="#Distribution">Distribution</a> |
<a href="#Description">Description</a>
				<a name="Connection"/>
				<h2>Connection Score: <xsl:value-of select="$connectionTotal"/>/<xsl:value-of
						select="$connectionMax"/></h2>
				<p>The ISO Standards for describing onlineResources make it possible to display
					meaningful titles and descriptions for URLs. This spiral checks that all of the
					URL names and descriptions exist.</p>
				<table width="95%" border="1" cellpadding="2" cellspacing="2">
					<tr>
						<th valign="top">Score</th>
						<th valign="top">Attribute (Count)</th>
						<th valign="top">Description</th>
						<th valign="top">Best Practice</th>
						<th valign="top">Path</th>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$onlineResourceURLExist"/>
						</xsl:call-template>
						<td valign="top">Online Resource URLs (<xsl:value-of
								select="$onlineResourceURLCnt"/>)</td>
						<td colspan="1" valign="top">URLs for online resources.</td>
						<td colspan="1" valign="top" rowspan="4">Information for Online Resources <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_Online_Resources"
								>More...</a></td>
						<td colspan="1" valign="top"
							>////gmd:CI_OnlineResource/gmd:linkage/gmd:URL</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$allOnlineResourceFunctionExist"/>
						</xsl:call-template>
						<td valign="top">Online Resource Functions (<xsl:value-of
								select="$onlineResourceFunctionCnt"/>)</td>
						<td colspan="1" valign="top">Function code for online resources. Valids
							include: download, information, offlineAccess, order, search</td>
						<td colspan="1" valign="top"
							>//gmd:CI_OnlineResource/gmd:function/gmd:CI_OnLineFunctionCode</td>
					</tr> <tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$allOnlineResourceNamesExist"/>
						</xsl:call-template>
						<td valign="top">Online Resource Names (<xsl:value-of
								select="$onlineResourceNameCnt"/>)</td>
						<td colspan="1" valign="top">Title for online resources, usually displayed
							as the link.</td>
						<td colspan="1" valign="top"
							>//gmd:CI_OnlineResource/gmd:name/gco:CharacterString</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$allOnlineResourceDescExist"/>
						</xsl:call-template>
						<td valign="top">Online Resource Description (<xsl:value-of
								select="$onlineResourceDescCnt"/>)</td>
						<td colspan="1" valign="top">A short paragraph describing an online
							resource, usually displayed with a link.</td>
						<td colspan="1" valign="top"
							>//gmd:CI_OnlineResource/gmd:description/gco:CharacterString</td>
					</tr>
				</table>
				<a href="#Identification">Identification</a> | <a href="#Extent">Extent</a> | <a
href="#Connection">Connection</a> | <a href="#Distribution">Distribution</a> |
<a href="#Description">Description</a>
				<a name="Distribution"/>
				<h2>Distribution Score: <xsl:value-of select="$distributionTotal"/>/<xsl:value-of
						select="$distributionMax"/></h2>
				<table width="95%" border="1" cellpadding="2" cellspacing="2">
					<tr>
						<th valign="top">Score</th>
						<th valign="top">Attribute (Count)</th>
						<th valign="top">Description</th>
						<th valign="top">Best Practice</th>
						<th valign="top">Path</th>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$distributorContactExist"/>
						</xsl:call-template>
						<td valign="top">Distributor Contact (<xsl:value-of
								select="$distributorContactCnt"/>)</td>
						<td colspan="1" valign="top">The contact for distribution of the
							resource.</td>
						<td colspan="1" valign="top">The organization directly responsible for
							distribution of the resource.</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:distributionInfo/gmd:MD_Distribution/gmd:distributor/gmd:MD_Distributor/gmd:distributorContact</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$distOnlineResourceExist"/>
						</xsl:call-template>
						<td valign="top">Online Resource (<xsl:value-of
								select="$distOnlineResourceCnt"/>)<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>O</a></td>
						<td colspan="1" valign="top">Information about Internet hosted resources:
							availability; URL; protocol used; resource name; resource description,
							and resource function.</td>
						<td colspan="1" valign="top">
							<a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_Online_Resources"
								>More...</a>
						</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:distributionInfo/gmd:MD_Distribution/gmd:distributor/gmd:MD_Distributor/gmd:distributorTransferOptions/gmd:MD_DigitalTransferOptions/gmd:onLine/gmd:CI_OnlineResource/gmd:linkage/gmd:URL)</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$distributionFormatExist"/>
						</xsl:call-template>
						<td valign="top">Resource Distribution Format (<xsl:value-of
								select="$distributionFormatCnt"/>)<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>O</a></td>
						<td colspan="1" valign="top">Description of distribution format.</td>
						<td colspan="1" valign="top"/>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:distributionInfo/gmd:MD_Distribution/gmd:distributor/gmd:MD_Distributor/gmd:distributorFormat/gmd:MD_Format)</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$dataCenterKeywordExist"/>
						</xsl:call-template>
						<td valign="top">Data Center Keywords (<xsl:value-of
								select="$dataCenterKeywordCnt"/>)<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (keywords)</a></td>
						<td colspan="1" valign="top">Keywords that describe a Data Center related to
							the resource.</td>
						<td valign="top" rowspan="2">The <a
								href="http://gcmd.nasa.gov/Resources/valids/">NASA Global Change
								Master Directory</a> is a good choice for keyword thesaurus</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='dataCenter']</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$dataCenterKeywordThesaurusExist"/>
						</xsl:call-template>
						<td valign="top">Data Center Keyword Thesaurus (<xsl:value-of
								select="$dataCenterKeywordThesaurusCnt"/>)<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (keywords_vocabulary)</a></td>
						<td colspan="1" valign="top">The name of a registered authoritative keyword
							resource.</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='dataCenter']/ancestor::node()/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gco:CharacterString</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$graphicOverviewCnt"/>
						</xsl:call-template>
						<td valign="top">Browse Graphic</td>
						<td colspan="1" valign="top">The name of, description of, and file type of
							an illustration of the dataset.</td>
						<td/>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:graphicOverview/gmd:MD_BrowseGraphic/gmd:fileName/gco:CharacterString</td>
					</tr>
				</table>
				<a href="#Identification">Identification</a> | <a href="#Extent">Extent</a> | <a
href="#Connection">Connection</a> | <a href="#Distribution">Distribution</a> |
<a href="#Description">Description</a>
				<a name="Description"/>
				<h2>Description Score: <xsl:value-of select="$descriptionTotal"/>/<xsl:value-of
						select="$descriptionMax"/></h2>
				<table width="95%" border="1" cellpadding="2" cellspacing="2">
					<tr>
						<th valign="top">Score</th>
						<th valign="top">Attribute (Count)</th>
						<th valign="top">Description</th>
						<th valign="top">Best Practice</th>
						<th valign="top">Path</th>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$purposeCnt"/>
						</xsl:call-template>
						<td valign="top">Purpose</td>
						<td colspan="1" valign="top">Summary of the intentions for which the dataset
							was developed.</td>
						<td colspan="1" valign="top">Purpose includes objectives for creating the
							dataset and what the dataset is to support.</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:purpose/gco:CharacterString</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$datasetExtentDescriptionCnt"/>
						</xsl:call-template>
						<td valign="top">Resource Extent Description</td>
						<td colspan="1" valign="top">Text which describes the spatial and temporal
							extent of the dataset.</td>
						<td valign="top">When referring to a named location this can be also listed
							as a keyword with type = "place". <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_Extents"
								>More...</a></td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent[@id='boundingExtent']/gmd:description/gco:CharacterString</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$lineageStatementCnt"/>
						</xsl:call-template>
						<td valign="top">Lineage Statement<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>O</a>, <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (history)</a></td>
						<td colspan="1" valign="top">General explanation of the data producer's
							knowledge of the resource sources and processing.</td>
						<td valign="top"/>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:dataQualityInfo/gmd:DQ_DataQuality/gmd:lineage/gmd:LI_Lineage/gmd:statement/gco:CharacterString</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$projectKeywordExist"/>
						</xsl:call-template>
						<td valign="top">Project Keywords (<xsl:value-of select="$projectKeywordCnt"
								/>)<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (keywords)</a></td>
						<td colspan="1" valign="top">Keywords that describe a Project related to the
							resource.</td>
						<td valign="top" rowspan="2">The <a
								href="http://gcmd.nasa.gov/Resources/valids/">NASA Global Change
								Master Directory</a> is a good choice for keyword thesaurus</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='project']</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$projectKeywordThesaurusExist"/>
						</xsl:call-template>
						<td valign="top">Project Keyword Thesaurus (<xsl:value-of
								select="$projectKeywordThesaurusCnt"/>)<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (keywords_vocabulary)</a></td>
						<td colspan="1" valign="top">The name of a registered authoritative keyword
							resource.</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='project']/ancestor::node()/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gco:CharacterString</td>
					</tr>
				</table>
				<a href="#Identification">Identification</a> | <a href="#Extent">Extent</a> | <a
					href="#Connection">Connection</a> | <a href="#Distribution">Distribution</a> |
					<a href="#Description">Description</a> | <a href="#Content">Content</a> | <a
					href="#Lineage">Lineage</a> | <a href="#Acquisition Information">Acquisition
					Information</a> | <a href="#WMO Profile">WMO Profile</a>
				
				<a name="ISO Core"/>
				<a name="ISO Core Mandatory"/>
				<h2>ISO Core Score: <xsl:value-of select="$ISOCoreTotal"/>/<xsl:value-of
						select="$ISOCoreMax"/></h2>
				<h2>Mandatory ISO Core Score: <xsl:value-of select="$ISOMandatoryTotal"
						/>/<xsl:value-of select="$ISOMandatoryMax"/></h2>
				<table width="95%" border="1" cellpadding="2" cellspacing="2">
					<tr>
						<th valign="top">Score</th>
						<th valign="top">Attribute (Count)</th>
						<th valign="top">Description</th>
						<th valign="top">Best Practice</th>
						<th valign="top">Path</th>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$titleCnt"/>
						</xsl:call-template>
						<td valign="top">Resource Title</td>
						<td colspan="1" valign="top">Name by which the dataset or resource is
							known</td>
						<td valign="top"/>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:title/gco:CharacterString</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$abstractCnt"/>
						</xsl:call-template>
						<td valign="top">Abstract</td>
						<td colspan="1" valign="top">Brief narrative summary of the resource
							contents.</td>
						<td colspan="1" valign="top">Abstract narrative should include information
							on general content and features; dataset application: GIS, CAD, image,
							database; geographic coverage: county/city name; time period of content:
							begin and end date or single date; and special data characteristics or
							limitations. Note: Many applications limit preliminary display to the
							first 150-200 characters of this field so critical distinguishing
							characteristics should be listed first.</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:abstract/gco:CharacterString</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$creationDateCnt"/>
						</xsl:call-template>
						<td valign="top">Creation Date</td>
						<td colspan="1" valign="top">Reference date for the cited resource;
							reference date and event used to describe it.</td>
						<td colspan="1" valign="top">Whenever possible, include both creation date
							and revision date. <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_Dates"
								>More...</a></td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:date/gmd:CI_Date/gmd:date/gco:Date</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$datasetLanguageCnt"/>
						</xsl:call-template>
						<td valign="top">Resource Language</td>
						<td colspan="1" valign="top">Languages of the resource using standard ISO
							three letter codes.</td>
						<td colspan="1" valign="top">Three letter language code followed by an
							optional three letter country code: &lt;ISO639-2/T three letter language
							code&gt;{&lt;blank space&gt;&lt;ISO3166-1 three letter country code&gt;}
							Language code is given in lowercase. Country code is given in uppercase.
							e.g. eng fra; CAN This attribute constitutes the default languages of
							the dataset. see
							http://www.loc.gov/standards/iso639-2/php/English_list.php for
							ISO639-2/T language codes; see http://userpage.chemie.fuberlin.
							de/diverse/doc/ISO_3166.html for ISO3166-1 country codes.</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:language/gmd:LanguageCode</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$topicCategoryExist"/>
						</xsl:call-template>
						<td valign="top">Topic Category (<xsl:value-of select="$topicCategoryCnt"
								/>)<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>M</a>, <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (keywords)</a></td>
						<td colspan="1" valign="top">The main theme(s) of the dataset.</td>
						<td colspan="1" valign="top">Select topicCategory from MD_TopicCategoryCode.
							Usually climatologyMeteorologyAtmosphere and/or oceans (keep this
							capitalization and spacing).</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:topicCategory/gmd:MD_TopicCategoryCode</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$metadataContactCnt"/>
						</xsl:call-template>
						<td valign="top">Metadata Contact<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>M</a>, <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (creator_name, URL, email)</a></td>
						<td colspan="1" valign="top">The responsible party for the metadata
							content.</td>
						<td colspan="1" valign="top">The organization directly responsible for
							metadata maintenance.</td>
						<td colspan="1" valign="top">/gmi:MI_Metadata/gmd:contact</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$metadataDateStampCnt"/>
						</xsl:call-template>
						<td valign="top">Metadata Creation Date</td>
						<td colspan="1" valign="top">Metadata creation date.</td>
						<td colspan="1" valign="top">Date of metadata creation or the last metadata
							update. <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_Dates"
								>More...</a></td>
						<td colspan="1" valign="top">/gmi:MI_Metadata/gmd:dateStamp</td>
					</tr>
				</table>
				<a name="ISO Core Conditional"/>
				<h2>Conditional ISO Core Score: <xsl:value-of select="$ISOConditionalTotal"
						/>/<xsl:value-of select="$ISOConditionalMax"/></h2>
				<table width="95%" border="1" cellpadding="2" cellspacing="2">
					<tr>
						<th valign="top">Score</th>
						<th valign="top">Attribute (Count)</th>
						<th valign="top">Description</th>
						<th valign="top">Best Practice</th>
						<th valign="top">Path</th>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$datasetExtentCnt"/>
						</xsl:call-template>
						<td valign="top">Resource Spatial Extent</td>
						<td colspan="1" valign="top">Describes the spatial, horizontal and/or
							vertical, and the temporal coverage in the resource.</td>
						<td colspan="1" valign="top">The bounding extent for the resource should be
							identified with id="boundingExtent": &lt;gmd:EX_Extent
							id="boundingExtent"&gt; <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_Extents"
								> More...</a></td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent[@id='boundingExtent']/gmd:geographicElement']</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$metadataLanguageCnt"/>
						</xsl:call-template>
						<td valign="top">Metadata Language</td>
						<td colspan="1" valign="top">Language of the metadata composed of an ISO639-
							2/T three letter language code and an ISO3166-1 three letter country
							code.</td>
						<td colspan="1" valign="top">Three letter language code followed by an
							optional three letter country code: &lt;ISO639-2/T three letter language
							code&gt;{&lt;;&gt;&lt;blank space&gt;&lt;ISO3166-1 three letter country
							code&gt;} Language code is given in lowercase. Country code is given in
							uppercase. e.g. eng fra; CAN This attribute constitutes the default
							languages of the dataset. see
							http://www.loc.gov/standards/iso639-2/php/English_list.php for
							ISO639-2/T language codes; see http://userpage.chemie.fuberlin.
							de/diverse/doc/ISO_3166.html for ISO3166-1 country codes.</td>
						<td colspan="1" valign="top">/gmi:MI_Metadata/gmd:language</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$metadataCharacterSetCnt"/>
						</xsl:call-template>
						<td valign="top">Metadata Character Set</td>
						<td colspan="1" valign="top">Character coding standard in the metadata.</td>
						<td colspan="1" valign="top">The character set for the metadata
							representation is restricted to "utf8", as used for ISO/TS19139:2007
							compliant XML encoding.</td>
						<td colspan="1" valign="top">/gmi:MI_Metadata/gmd:characterSet</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$datasetCharacterSetCnt"/>
						</xsl:call-template>
						<td valign="top">Resource Character Set</td>
						<td colspan="1" valign="top">Character coding standard in the resource.</td>
						<td colspan="1" valign="top">The default value of the character set for the
							resource representation is "utf8." The character set should be reported
							for any resource that uses characters for its representation. Resources
							such as image and video for instance might not make use of character
							set. When dataset includes North American aboriginal languages, the
							character set will not usually be "utf8."</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:characterSet</td>
					</tr>
				</table>
				<a name="ISO Core Optional"/>
				<h2>Optional ISO Core Score: <xsl:value-of select="$ISOOptionalTotal"
						/>/<xsl:value-of select="$ISOOptionalMax"/></h2>
				<table width="95%" border="1" cellpadding="2" cellspacing="2">
					<tr>
						<th valign="top">Score</th>
						<th valign="top">Attribute (Count)</th>
						<th valign="top">Description</th>
						<th valign="top">Best Practice</th>
						<th valign="top">Path</th>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$temporalCnt"/>
						</xsl:call-template>
						<td valign="top">Temporal Extent</td>
						<td colspan="1" valign="top">Describes the temporal coverage in the
							resource.</td>
						<td colspan="1" valign="top">A temporal element could be used to describe
							either the time period covered by the content of the dataset (e.g.
							during the Jurassic) or the date and time when the data has been
							collected (e.g. the date on which the geological study was completed).
							If both are needed, then two temporal extents should be provided. The
							use of multiple temporal extents should be explained in the attribute
							description of the extent. The bounding extent for the resource should
							be identified with id="boundingExtent": &lt;gmd:EX_Extent
							id="boundingExtent"&gt; <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_Extents"
								>More...</a></td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent[@id='boundingExtent']/gmd:temporalElement/gmd:EX_TemporalExtent/gmd:extent</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$verticalCnt"/>
						</xsl:call-template>
						<td valign="top">Vertical Extent</td>
						<td colspan="1" valign="top">The elements which give the minimum and maximum
							of the vertical extent of the dataset.</td>
						<td colspan="1" valign="top">The bounding extent for the resource should be
							identified with id="boundingExtent": &lt;gmd:EX_Extent
							id="boundingExtent"&gt; <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_Extents"
								>More...</a></td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent[@id='boundingExtent']/gmd:verticalElement/gmd:EX_VerticalExtent</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$resourceContactExist"/>
						</xsl:call-template>
						<td valign="top">Resource Contact (<xsl:value-of
								select="$resourceContactCnt"/>)<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>O</a>, <a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=NetCDF_Attribute_Convention_for_Dataset_Discovery"
								>UDD (creator_name, URL, email)</a></td>
						<td colspan="1" valign="top">Identification and means to contact
							people/organizations associated with the resource.</td>
						<td colspan="1" valign="top">The person/organization directly responsible
							for answering questions about a resource. This could be a person at an
							archive rather than the originator of the resource (described in the
							citation).</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:pointOfContact/gmd:CI_ResponsibleParty)</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$lineageExist"/>
						</xsl:call-template>
						<td valign="top">Resource Lineage (<xsl:value-of select="$lineageCnt"
							/>)</td>
						<td colspan="1" valign="top">Information or lack of information on the
							events and source data used to construct the resource.</td>
						<td colspan="1" valign="top"/>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:dataQualityInfo/gmd:DQ_DataQuality/gmd:lineage/gmd:LI_Lineage)</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$idCnt"/>
						</xsl:call-template>
						<td valign="top">Metadata Identifier</td>
						<td colspan="1" valign="top">A unique phrase or string which uniquely
							identifies the metadata file.</td>
						<td colspan="1" valign="top">Each metadata record shall have a unique
							identifier, such as a universal unique identifier (UUID), to distinguish
							it from other resources.</td>
						<td colspan="1" valign="top">/gmi:MI_Metadata/gmd:fileidentifier</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$distOnlineResourceExist"/>
						</xsl:call-template>
						<td valign="top">Online Resource (<xsl:value-of
								select="$distOnlineResourceCnt"/>)<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>O</a></td>
						<td colspan="1" valign="top">Information about Internet hosted resources:
							availability; URL; protocol used; resource name; resource description,
							and resource function.</td>
						<td colspan="1" valign="top">
							<a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_Online_Resources"
								>More...</a>
						</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:distributionInfo/gmd:MD_Distribution/gmd:distributor/gmd:MD_Distributor/gmd:distributorTransferOptions/gmd:MD_DigitalTransferOptions/gmd:onLine/gmd:CI_OnlineResource/gmd:linkage/gmd:URL)</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$spatialRepresentationTypeCnt"/>
						</xsl:call-template>
						<td valign="top">Spatial Representation Type</td>
						<td colspan="1" valign="top">Object(s) used to represent the geographic
							information.</td>
						<td colspan="1" valign="top">Select spatialRepresentationType from
							MD_SpatialRepresentationTypeCode.</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:spatialRepresentationType)</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$distributionFormatExist"/>
						</xsl:call-template>
						<td valign="top">Resource Distribution Format (<xsl:value-of
								select="$distributionFormatCnt"/>)<br/><a
								href="https://geo-ide.noaa.gov/wiki/index.php?title=ISO_19115_Core_Elements"
								>O</a></td>
						<td colspan="1" valign="top">Description of distribution format.</td>
						<td colspan="1" valign="top"/>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:distributionInfo/gmd:MD_Distribution/gmd:distributor/gmd:MD_Distributor/gmd:distributorFormat/gmd:MD_Format)</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$metadataStandardNameCnt"/>
						</xsl:call-template>
						<td valign="top">Metadata Standard</td>
						<td colspan="1" valign="top">Name of the metadata standard/profile
							used.</td>
						<td colspan="1" valign="top">ISO 19115-2 Geographic Information - Metadata
							Part 2 Extensions for imagery and gridded data</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:metadataStandardName/gco:CharacterString)</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$metadataStandardVersionCnt"/>
						</xsl:call-template>
						<td valign="top">Metadata Version</td>
						<td colspan="1" valign="top">Version of the metadata standard/profile
							used.</td>
						<td colspan="1" valign="top">ISO 19115-2:2009(E)</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:metadataStandardVersion/gco:CharacterString)</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$referenceSystemCnt"/>
						</xsl:call-template>
						<td valign="top">Resource Reference System</td>
						<td colspan="1" valign="top">Description of the spatial and/or temporal
							reference systems used in the dataset.</td>
						<td colspan="1" valign="top">Multiple instances of Reference System
							Information are authorized to describe the coordinate systems being used
							for coordinate representation (horizontal, vertical and/or
							temporal).</td>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:referenceSystemInfo/gmd:MD_ReferenceSystem)</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$spatialResolutionCnt"/>
						</xsl:call-template>
						<td valign="top">Resource Spatial Resolution</td>
						<td colspan="1" valign="top">The level of detail of the dataset expressed as
							equivalent scale or ground distance.</td>
						<td colspan="1" valign="top"/>
						<td colspan="1" valign="top"
							>/gmi:MI_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:spatialResolution/gmd:MD_Resolution)</td>
					</tr>
				</table>
				
				<!--wmo profile score-->
				<a name="WMO Profile"/>
				<h2>WMO Profile Score: <xsl:value-of select="$WMOProfileTotal"/>/<xsl:value-of select="$WMOProfileMax"/></h2>
				<table width="95%" border="1" cellpadding="2" cellspacing="2">
					<tr>
						<th valign="top">Score</th>
						<th valign="top">Attribute (Count)</th>
						<th valign="top">Description</th>
						<th valign="top">Best Practice</th>
						<th valign="top">Path</th>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$fileIdentifierExist"/>
						</xsl:call-template>
						<td valign="top">File Identifier (<xsl:value-of select="$fileIdentifierExist"
						/>)<br/></td>
						<td>The file identifier for the metadata record.</td>
						<td colspan="1" valign="top">Each metadata record shall have a unique identifier, such as a universal unique identifier (UUID), 
							to distinguish it from other resources.  The WMO Core Metadata Profile recommends that gmd:MD_Metadata/gmd:fileIdentifier is a URI
							(Universal Resource Identifier) structured as follows:<a
								href="http://wis.wmo.int/2010/metadata/version_1-2/WMO%20Core%20Metadata%20Profile%20v1-2%20Guidance%20Documentation%20v0.1%20%28DRAFT%29.pdf"
								> More...</a> </td>
						<td colspan="1" valign="top"
							>/gmd:MD_Metadata/gmd:fileIdentifier/gco:CharacterString</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$hierarchyLevelCnt"/>
						</xsl:call-template>
						<td valign="top">Resource Hierarchy Level (<xsl:value-of select="$hierarchyLevelCnt"/>)<br/></td>
						<td colspan="1" valign="top">The MD_ScopeCode used to describe the resource hierarchy.</td>
						<td colspan="1" valign="top">Zero or one hierarchyLevel element can be utilized in a single metadata record. Fundamental to ISO19115 are the concepts of dataset (DS_DataSet) and aggregations
							(DS_Aggregate). The hierarchy level is described in each metadata record via the gmd:hierarchyLevel
							element; selecting the appropriate value from the MD_ScopeCode «CodeList».  Aggregations, or collections, of 
							datasets can be of many types including series, platforms and sensors etc. Every type of aggregation can include subsets 
							and/or discrete datasets. Similar to a file system directory structure, the DS_Aggregate class provides a mechanism for 
							organizing/grouping metadata content into documentation levels based on hierarchy. <a href="http://geo-ide.noaa.gov/wiki/index.php?title=Metadata_Hierarchies"> More ...</a> 
						</td>
						<td colspan="1" valign="top"
							>/gmd:MD_Metadata/gmd:hierarchyLevel/gmd:MD_ScopeCode</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$hierarchyLevelNameCnt"/>
						</xsl:call-template>
						<td valign="top">Resource Hierarchy Level Name (<xsl:value-of
							select="$hierarchyLevelNameCnt"/>)<br/></td>
						<td colspan="1" valign="top">HierarchyLevelName provides an alternative description for the resource hierarchy level.</td>
						<td colspan="1" valign="top">Zero or one hierarchyLevelName element can be used to supplement the hierarchyLevel element with more descriptive text. 
							It may also be used in lieu of the hierachyLevel element if none of the MD_ScopeCode options are appropriate. 
						</td>
						<td colspan="1" valign="top"
							>/gmd:MD_Metadata/gmd:hierarchyLevelName/gco:CharacterString</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$wmoKeywordCheck"/>
						</xsl:call-template>
						<td valign="top">WMO Category Code (<xsl:value-of
							select="$wmoKeywordCheck"/>)<br/></td>
						<td colspan="1" valign="top">A keyword value from the WMO category codelist.</td>
						<td colspan="1" valign="top">A minimum of one descriptiveKeyword from the WMO_CategoryCode codelist is required. 
							The MD_KeywordTypeCode (selected from the ISO MD_KeywordTypeCode codelist) for this entry must be 'theme'.
							All keyword elements sourced from a particular thesaurus shall be grouped into a single instance of the
							MD_Keywords class.
						</td>
						<td colspan="1" valign="top"
							>/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:keyword/gco:CharacterString</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$topicCategoryExist"/>
						</xsl:call-template>
						<td valign="top">Topic Category Code (<xsl:value-of
							select="$topicCategoryExist"/>)<br/></td>
						<td colspan="1" valign="top">The topic code classification for the resource.</td>
						<td colspan="1" valign="top">Select one or more categories that most closely represent the topic of the data resource.
							Categories must be selected from the ISO MD_TopicCategory Enumeration list.
						</td>
						<td colspan="1" valign="top"
							>/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:topicCategory/gmd:MD_TopicCategoryCode</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$boundingExtentsExist"/>
						</xsl:call-template>
						<td valign="top">Bounding Extent (<xsl:value-of
							select="$boundingExtentsExist"/>)<br/></td>
						<td colspan="1" valign="top">The spatial extent of the resource.</td>
						<td colspan="1" valign="top">A minimum of one EX_GeographicBounding Box is required to define the spatial extent of the resource.  If the spatial extent is the bounding extent,
							then the EX_GeographicBoundingBox element should be identified with attribute id="boundingExtent".
						</td>
						<td colspan="1" valign="top"
							>/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/</td>
					</tr>
				</table>
				<!--  -->
				
				<!--inspire profile score-->
				<a name="INSPIRE Profile"/>
				<h2>INSPIRE Compliance (Recommended for WMO): <xsl:value-of select="$InspireComplianceTotal"/>/<xsl:value-of select="$InspireComplianceTotalMax"/></h2>
				<table width="95%" border="1" cellpadding="2" cellspacing="2">
					<tr>
						<th valign="top">Score</th>
						<th valign="top">Attribute (Count)</th>
						<th valign="top">Description</th>
						<th valign="top">Best Practice</th>
						<th valign="top">Path</th>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$resourceUseLimitationExist"/>
						</xsl:call-template>
						<td valign="top">Resource Use Limitation(<xsl:value-of
							select="$resourceUseLimitationExist"/>)<br/></td>
						<td colspan="1" valign="top">A description of the use limitations for the resource.</td>
						<td colspan="1" valign="top">This element describes any restrictions on usage of the data. Use constraints are
							different from restrictions on public access which describe limitations on access to the data. A data
							resource can have open access, but restricted use. If no conditions apply, then a phrase such as 'No conditions apply'
							should be recorded. Required for compliance with INSPIRE implementing rules.
						</td>
						<td colspan="1" valign="top"
							>/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:resourceConstraints/gmd:MD_Constraints/gmd:useLimitation/gco:CharacterString</td>
					</tr>
					<tr>
						<xsl:call-template name="showScore">
							<xsl:with-param name="score" select="$qualityReportExist"/>
						</xsl:call-template>
						<td valign="top">Resource Quality Report (<xsl:value-of
							select="$qualityReportExist"/>)<br/></td>
						<td colspan="1" valign="top">A report that describes the quality or conformance of the resource.</td>
						<td colspan="1" valign="top">Use the report object to describe the degree of conformity to a specification such as the INSPIRE implementing rules. 
							Required for compliance with INSPIRE implementing rules.
						</td>
						<td colspan="1" valign="top"
							>/gmd:MD_Metadata/gmd:dataQualityInfo/gmd:DQ_DataQuality/gmd:report</td>
					</tr>				
				</table>
				<!--  -->
				<br/>
				<!--<xsl:call-template name="stars"/>-->
				<!--  -->
			</body>
		</html>
	</xsl:template>
	<xsl:template name="showColumn">
		<xsl:param name="name"/>
		<xsl:param name="total"/>
		<xsl:param name="max"/>
		<xsl:variable name="column">
			<xsl:choose>
				<xsl:when test="$total=0">0</xsl:when>
				<xsl:when test="$total=$max">4</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="floor(number(number($total) * 3 div number($max)))+1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<tr>
			<td width="20%">
				<a href="#{$name}">
					<xsl:value-of select="$name"/>
				</a>
			</td>
			<xsl:choose>
				<xsl:when test="$column=0">
					<td align="center" bgcolor="CC00CC"/>
				</xsl:when>
				<xsl:otherwise>
					<td/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="$column=1">
					<td align="center" bgcolor="CC00CC"/>
				</xsl:when>
				<xsl:otherwise>
					<td/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="$column=2">
					<td align="center" bgcolor="CC00CC"/>
				</xsl:when>
				<xsl:otherwise>
					<td/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="$column=3">
					<td align="center" bgcolor="CC00CC"/>
				</xsl:when>
				<xsl:otherwise>
					<td/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="$column=4">
					<td align="center" bgcolor="CC00CC"/>
				</xsl:when>
				<xsl:otherwise>
					<td/>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
	</xsl:template>
	<xsl:template name="showScore">
		<xsl:param name="score"/>
		<xsl:choose>
			<xsl:when test="$score=1">
				<td align="center" bgcolor="66CC66">
					<xsl:value-of select="$score"/>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td align="center" bgcolor="FF0033">
					<xsl:value-of select="$score"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
