<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:gmd="http://www.isotc211.org/2005/gmd" 
  xmlns:gco="http://www.isotc211.org/2005/gco"
  xmlns:gml="http://www.opengis.net/gml/3.2"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xmlns:xlink="http://www.w3.org/1999/xlink"
  >

<xsl:output method="text"/>

<xsl:template match="/">
  <xsl:apply-templates select="*"/>
</xsl:template>

<xsl:template match="*[gco:* or gmd:URL]">
  <xsl:param name="indent"/>
  <xsl:value-of select="concat($indent, local-name(), ': ',
    normalize-space(.), '&#10;')"/>
  <xsl:apply-templates select="@*">
    <xsl:with-param name="indent" select="concat('| ', $indent)"/>
  </xsl:apply-templates>
</xsl:template>

<xsl:template match="*[*/@codeListValue]">
  <xsl:param name="indent"/>
  <xsl:value-of select="concat($indent, local-name(), ': ',
    normalize-space(*/@codeListValue), '&#10;')"/>
</xsl:template>

<xsl:template match="*[starts-with(translate(local-name(),
	'ABCDEFGHIJKLMNOPQRSTUVWXYZ',
	'ZZZZZZZZZZZZZZZZZZZZZZZZZZ'),'ZZ_')]">
  <xsl:param name="indent"/>
  <xsl:value-of select="concat($indent, local-name(), '&#10;')"/>
  <xsl:apply-templates select="*|@*">
    <xsl:with-param name="indent" select="$indent"/>
  </xsl:apply-templates>
</xsl:template>

<xsl:template match="*">
  <xsl:param name="indent"/>
  <xsl:value-of select="concat($indent, local-name(), ': ',
    normalize-space(text()), '&#10;')"/>
  <xsl:apply-templates select="*|@*">
    <xsl:with-param name="indent" select="concat('| ', $indent)"/>
  </xsl:apply-templates>
</xsl:template>

<xsl:template match="@xsi:schemaLocation">
</xsl:template>

<xsl:template match="@*">
  <xsl:param name="indent"/>
  <xsl:value-of select="concat($indent, '@', local-name(), ': ',
    normalize-space(.), '&#10;')"/>
</xsl:template>

</xsl:stylesheet>
