<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" 
	xmlns:gco="http://www.isotc211.org/2005/gco" 
	xmlns:gmd="http://www.isotc211.org/2005/gmd"
	xmlns:gmx="http://www.isotc211.org/2005/gmx" 
	xmlns:gml="http://www.opengis.net/gml"
	xmlns:gts="http://www.isotc211.org/2005/gts" 
	xmlns:gmi="http://www.isotc211.org/2005/gmi" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xlink="http://www.w3.org/1999/xlink">
	<xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" scope="stylesheet">
		<xd:desc>
			<xd:p><xd:b>Created on:</xd:b> May 4, 2010</xd:p>
			<xd:p><xd:b>Author:</xd:b> ted.habermann@noaa.gov</xd:p>
			<xd:p><xd:b>Author:</xd:b> john.kozimor@noaa.gov</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:include href="isoRubricStars.xsl"/>
	<!-- global variables to identify version, generation date and record set.
        Note that this assumes that there is an xmlFiles.lst file in the current directory 
        /// @todo: would be better to use passed in parameters and XSLT 2.0 dateTime...  -->
	<xsl:variable name="rubricVersion" select="'1.0.3'"/>
	<xsl:variable name="recordSet" select="document('xmlFiles.lst', /)/fileList/filesDirFull"/>
	<!-- Parameters to identify files to score -->
	<xsl:param name="recordSetPath"/>
	<xsl:param name="fileNamePattern"/>
	<xsl:param name="rootElement"></xsl:param>
	<xsl:template match="/">
		<xsl:variable name="xmlFilesSelect" select="concat($recordSetPath, '?select=',$fileNamePattern)"/>
		
		<!--WMO Profile Constraints-->
		
		<xsl:for-each select="collection(iri-to-uri($xmlFilesSelect))">
			<xsl:variable name="keywordTypeCodeTheme" select="//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:type/gmd:MD_KeywordTypeCode[@codeListValue='theme']"></xsl:variable>
			<xsl:variable name="wmoCatCodeRef" select="//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:thesaurusName/gmd:CI_Citation/gmd:title/gmx:Anchor/@xlink:href='http://www.wmo.int/wmo_categoryCodelist'"></xsl:variable>
			<xsl:variable name="wmoCatCodes" select="//gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:keyword/gco:CharacterString[text()='weatherObservations' or text()='weatherForecasts' or text()='meteorology' or text()='hydrology' or text()='climatology'          or text()='landMeteorologyClimate' or text()='synopticMeteorology' or text()='marineMeteorology' or text()='agriculturalMeteorology' or text()='aerology'          or text()='marineAerology' or text()='oceanography' or text()='landHydrology' or text()='rocketSounding' or text()='pollution' or text()='waterPollution'          or text()='landWaterPollution' or text()='seaPollution' or text()='landPollution' or text()='airPollution' or text()='glaciology'          or text()='actinometry' or text()='satelliteObservation' or text()='airplaneObservation' or text()='observationPlatform']"></xsl:variable>
			<xsl:variable name="title" select="//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:title/gco:CharacterString"/>
			<xsl:variable name="fileIdentifierExist">
				<xsl:choose>
					<xsl:when test="(/gmd:MD_Metadata/gmd:fileIdentifier/gco:CharacterString != '')">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="hierarchyLevelCnt">
				<xsl:choose>
					<xsl:when test="(count(/gmd:MD_Metadata/gmd:hierarchyLevel)=0) or (count(/gmd:MD_Metadata/gmd:hierarchyLevel)=1)">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="hierarchyLevelNameCnt">
				<xsl:choose>
					<xsl:when test="(count(/gmd:MD_Metadata/gmd:hierarchyLevelName)=0) or (count(/gmd:MD_Metadata/gmd:hierarchyLevelName)=1)">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="wmoKeywordCheck">
				<xsl:choose>
					<xsl:when test="($wmoCatCodeRef) and ($keywordTypeCodeTheme) and ($wmoCatCodes)">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="topicCategoryExist">
				<xsl:choose>
					<xsl:when test="(/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:topicCategory/gmd:MD_TopicCategoryCode !='')">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="boundingExtentsExist">
				<xsl:choose>
					<xsl:when test="(//gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/gmd:westBoundLongitude/gco:Decimal != '')
						and (//gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/gmd:eastBoundLongitude/gco:Decimal != '')
						and (//gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/gmd:northBoundLatitude/gco:Decimal != '')
						and (//gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/gmd:southBoundLatitude/gco:Decimal != '')">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="resourceUseLimitationExist">
				<xsl:choose>
					<xsl:when test="(/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:resourceConstraints/gmd:MD_Constraints/gmd:useLimitation/gco:CharacterString !='')">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="qualityReportExist">
				<xsl:choose>
					<xsl:when test="(/gmd:MD_Metadata/gmd:dataQualityInfo/gmd:DQ_DataQuality/gmd:report)">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="WMOProfileTotal" select="$fileIdentifierExist + $hierarchyLevelCnt + $hierarchyLevelNameCnt + $topicCategoryExist + $boundingExtentsExist + $wmoKeywordCheck + $resourceUseLimitationExist + $qualityReportExist"/>
			<xsl:variable name="WMOProfileMax">8</xsl:variable>
			
			<!-- Spiral Scores -->

			<xsl:value-of select="$rubricVersion"/>|<xsl:value-of select="current-date()"/>|<xsl:value-of select="$recordSetPath"/>|<xsl:value-of select="normalize-space($title)"/>|<xsl:value-of
				select="normalize-space(//gmd:fileIdentifier/gco:CharacterString)"/>|<xsl:value-of select="$WMOProfileTotal"/>|<xsl:value-of select="$WMOProfileMax"/>
			<!-- output a newline -->
			<xsl:text>&#xa;</xsl:text>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
