package de.dwd.gisc.md;

import java.io.File;
import java.io.FilenameFilter;

import org.jdom.Document;
import org.jdom.input.SAXBuilder;

public class ISOValidator implements FilenameFilter {
	public static final String SAXPARSER = "org.apache.xerces.parsers.SAXParser";
	public static final String VALIDATION = "http://apache.org/xml/features/validation/schema";
	public static final String EXTERNAL_SCHEMALOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
	public static final String GMD_SCHEMA = "http://www.isotc211.org/2005/gmd iso19139/schema.321/gmd/gmd.xsd http://www.isotc211.org/2005/gmx iso19139/schema.321/gmx/gmx.xsd";
	
	private static Document s_doc = null;
	
	public static void moveFile(String source, String dest) {
		File sourceFile = new File(source);
		sourceFile.renameTo(new File(dest));
	}
	
	public static boolean validate (String fileName) {
		boolean flag = false;
		SAXBuilder builder =
			  new SAXBuilder(SAXPARSER, true);
			builder.setFeature(VALIDATION , true);
			
			builder.setProperty( EXTERNAL_SCHEMALOCATION , GMD_SCHEMA  );
			try { 
				File file = new File(fileName);
				Document doc = builder.build(file);
				s_doc = doc;
			} catch (Exception e) {
				System.out.println("Error in file: " + fileName + " message: " + e.toString());
				s_doc = null;
				return flag;
			}
			flag = true;
			return flag;
			}
				
	public static void process () {
		
	}
	
	public static void main(String[] args) {
		if (args.length != 2) {
			System.out.println("Usage: java ISOValidator inputDir invalidDir");
			System.exit(99);
		}
		
		FilenameFilter filter = new ISOValidator();
		File inputDir = new File(args[0]);
		String[] files = inputDir.list(filter);
	
		for (int i = 0 ; i < files.length; i++ ) {
			long starttime = System.currentTimeMillis();
			String inputFile = args[0] + File.separator + files[i];
			String outputFile = args[1] + File.separator + files[i];
			boolean isValid = validate(inputFile);
			if(!isValid) {
				moveFile(inputFile,outputFile);
			} else {
				
			}
			System.out.println( files[i] + " validated in " + (System.currentTimeMillis() - starttime) + " ms");
		} // for-ends
	} // main-ends
	
	public boolean accept(File file, String name) {
		return (name.endsWith(".xml"));
	}
	
}
