<?xml version="1.0" encoding="UTF-8"?>
<!-- taken from https://bitbucket.org/vaporoid/vaporoid-hash -->
<!--
  Licensed to the Apache Software Foundation (ASF) under one or more
  contributor license agreements.  See the NOTICE file distributed with this
  work for additional information regarding copyright ownership.  The ASF
  licenses this file to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
  WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
  License for the specific language governing permissions and limitations under
  the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:key name="vaporoid-hash-table" match="item" use="@key"/>
  <xsl:variable name="endl">
    <xsl:text>
</xsl:text>
  </xsl:variable>
  <xsl:template name="uint4-bitwise-and">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:for-each select="document('vaporoid-hash-uint4-bitwise-and.xml')">
      <xsl:value-of select="key('vaporoid-hash-table', concat($a, 'x' ,$b))"/>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="uint4-bitwise-xor">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:for-each select="document('vaporoid-hash-uint4-bitwise-xor.xml')">
      <xsl:value-of select="key('vaporoid-hash-table', concat($a, 'x' ,$b))"/>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="uint4-bitwise-or">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:for-each select="document('vaporoid-hash-uint4-bitwise-or.xml')">
      <xsl:value-of select="key('vaporoid-hash-table', concat($a, 'x' ,$b))"/>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="uint8-bitwise-and">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:variable name="upper">
      <xsl:call-template name="uint4-bitwise-and">
        <xsl:with-param name="a" select="floor($a div 16)"/>
        <xsl:with-param name="b" select="floor($b div 16)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="lower">
      <xsl:call-template name="uint4-bitwise-and">
        <xsl:with-param name="a" select="$a mod 16"/>
        <xsl:with-param name="b" select="$b mod 16"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="$upper * 16 + $lower"/>
  </xsl:template>
  <xsl:template name="uint8-bitwise-xor">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:variable name="upper">
      <xsl:call-template name="uint4-bitwise-xor">
        <xsl:with-param name="a" select="floor($a div 16)"/>
        <xsl:with-param name="b" select="floor($b div 16)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="lower">
      <xsl:call-template name="uint4-bitwise-xor">
        <xsl:with-param name="a" select="$a mod 16"/>
        <xsl:with-param name="b" select="$b mod 16"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="$upper * 16 + $lower"/>
  </xsl:template>
  <xsl:template name="uint8-bitwise-or">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:variable name="upper">
      <xsl:call-template name="uint4-bitwise-or">
        <xsl:with-param name="a" select="floor($a div 16)"/>
        <xsl:with-param name="b" select="floor($b div 16)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="lower">
      <xsl:call-template name="uint4-bitwise-or">
        <xsl:with-param name="a" select="$a mod 16"/>
        <xsl:with-param name="b" select="$b mod 16"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="$upper * 16 + $lower"/>
  </xsl:template>
  <xsl:template name="uint8-decode">
    <xsl:param name="byte"/>
    <xsl:for-each select="document('vaporoid-hash-uint8-decode.xml')">
      <xsl:value-of select="key('vaporoid-hash-table', $byte)"/>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="uint8-encode">
    <xsl:param name="word"/>
    <xsl:choose>
      <xsl:when test="$word = 0">
        <xsl:text>00</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 1">
        <xsl:text>01</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 2">
        <xsl:text>02</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 3">
        <xsl:text>03</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 4">
        <xsl:text>04</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 5">
        <xsl:text>05</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 6">
        <xsl:text>06</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 7">
        <xsl:text>07</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 8">
        <xsl:text>08</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 9">
        <xsl:text>09</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 10">
        <xsl:text>0a</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 11">
        <xsl:text>0b</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 12">
        <xsl:text>0c</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 13">
        <xsl:text>0d</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 14">
        <xsl:text>0e</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 15">
        <xsl:text>0f</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 16">
        <xsl:text>10</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 17">
        <xsl:text>11</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 18">
        <xsl:text>12</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 19">
        <xsl:text>13</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 20">
        <xsl:text>14</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 21">
        <xsl:text>15</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 22">
        <xsl:text>16</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 23">
        <xsl:text>17</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 24">
        <xsl:text>18</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 25">
        <xsl:text>19</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 26">
        <xsl:text>1a</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 27">
        <xsl:text>1b</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 28">
        <xsl:text>1c</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 29">
        <xsl:text>1d</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 30">
        <xsl:text>1e</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 31">
        <xsl:text>1f</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 32">
        <xsl:text>20</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 33">
        <xsl:text>21</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 34">
        <xsl:text>22</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 35">
        <xsl:text>23</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 36">
        <xsl:text>24</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 37">
        <xsl:text>25</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 38">
        <xsl:text>26</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 39">
        <xsl:text>27</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 40">
        <xsl:text>28</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 41">
        <xsl:text>29</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 42">
        <xsl:text>2a</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 43">
        <xsl:text>2b</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 44">
        <xsl:text>2c</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 45">
        <xsl:text>2d</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 46">
        <xsl:text>2e</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 47">
        <xsl:text>2f</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 48">
        <xsl:text>30</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 49">
        <xsl:text>31</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 50">
        <xsl:text>32</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 51">
        <xsl:text>33</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 52">
        <xsl:text>34</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 53">
        <xsl:text>35</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 54">
        <xsl:text>36</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 55">
        <xsl:text>37</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 56">
        <xsl:text>38</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 57">
        <xsl:text>39</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 58">
        <xsl:text>3a</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 59">
        <xsl:text>3b</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 60">
        <xsl:text>3c</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 61">
        <xsl:text>3d</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 62">
        <xsl:text>3e</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 63">
        <xsl:text>3f</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 64">
        <xsl:text>40</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 65">
        <xsl:text>41</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 66">
        <xsl:text>42</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 67">
        <xsl:text>43</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 68">
        <xsl:text>44</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 69">
        <xsl:text>45</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 70">
        <xsl:text>46</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 71">
        <xsl:text>47</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 72">
        <xsl:text>48</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 73">
        <xsl:text>49</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 74">
        <xsl:text>4a</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 75">
        <xsl:text>4b</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 76">
        <xsl:text>4c</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 77">
        <xsl:text>4d</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 78">
        <xsl:text>4e</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 79">
        <xsl:text>4f</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 80">
        <xsl:text>50</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 81">
        <xsl:text>51</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 82">
        <xsl:text>52</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 83">
        <xsl:text>53</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 84">
        <xsl:text>54</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 85">
        <xsl:text>55</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 86">
        <xsl:text>56</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 87">
        <xsl:text>57</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 88">
        <xsl:text>58</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 89">
        <xsl:text>59</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 90">
        <xsl:text>5a</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 91">
        <xsl:text>5b</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 92">
        <xsl:text>5c</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 93">
        <xsl:text>5d</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 94">
        <xsl:text>5e</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 95">
        <xsl:text>5f</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 96">
        <xsl:text>60</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 97">
        <xsl:text>61</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 98">
        <xsl:text>62</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 99">
        <xsl:text>63</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 100">
        <xsl:text>64</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 101">
        <xsl:text>65</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 102">
        <xsl:text>66</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 103">
        <xsl:text>67</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 104">
        <xsl:text>68</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 105">
        <xsl:text>69</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 106">
        <xsl:text>6a</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 107">
        <xsl:text>6b</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 108">
        <xsl:text>6c</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 109">
        <xsl:text>6d</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 110">
        <xsl:text>6e</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 111">
        <xsl:text>6f</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 112">
        <xsl:text>70</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 113">
        <xsl:text>71</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 114">
        <xsl:text>72</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 115">
        <xsl:text>73</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 116">
        <xsl:text>74</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 117">
        <xsl:text>75</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 118">
        <xsl:text>76</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 119">
        <xsl:text>77</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 120">
        <xsl:text>78</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 121">
        <xsl:text>79</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 122">
        <xsl:text>7a</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 123">
        <xsl:text>7b</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 124">
        <xsl:text>7c</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 125">
        <xsl:text>7d</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 126">
        <xsl:text>7e</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 127">
        <xsl:text>7f</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 128">
        <xsl:text>80</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 129">
        <xsl:text>81</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 130">
        <xsl:text>82</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 131">
        <xsl:text>83</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 132">
        <xsl:text>84</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 133">
        <xsl:text>85</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 134">
        <xsl:text>86</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 135">
        <xsl:text>87</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 136">
        <xsl:text>88</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 137">
        <xsl:text>89</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 138">
        <xsl:text>8a</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 139">
        <xsl:text>8b</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 140">
        <xsl:text>8c</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 141">
        <xsl:text>8d</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 142">
        <xsl:text>8e</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 143">
        <xsl:text>8f</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 144">
        <xsl:text>90</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 145">
        <xsl:text>91</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 146">
        <xsl:text>92</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 147">
        <xsl:text>93</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 148">
        <xsl:text>94</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 149">
        <xsl:text>95</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 150">
        <xsl:text>96</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 151">
        <xsl:text>97</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 152">
        <xsl:text>98</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 153">
        <xsl:text>99</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 154">
        <xsl:text>9a</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 155">
        <xsl:text>9b</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 156">
        <xsl:text>9c</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 157">
        <xsl:text>9d</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 158">
        <xsl:text>9e</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 159">
        <xsl:text>9f</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 160">
        <xsl:text>a0</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 161">
        <xsl:text>a1</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 162">
        <xsl:text>a2</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 163">
        <xsl:text>a3</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 164">
        <xsl:text>a4</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 165">
        <xsl:text>a5</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 166">
        <xsl:text>a6</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 167">
        <xsl:text>a7</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 168">
        <xsl:text>a8</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 169">
        <xsl:text>a9</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 170">
        <xsl:text>aa</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 171">
        <xsl:text>ab</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 172">
        <xsl:text>ac</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 173">
        <xsl:text>ad</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 174">
        <xsl:text>ae</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 175">
        <xsl:text>af</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 176">
        <xsl:text>b0</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 177">
        <xsl:text>b1</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 178">
        <xsl:text>b2</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 179">
        <xsl:text>b3</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 180">
        <xsl:text>b4</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 181">
        <xsl:text>b5</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 182">
        <xsl:text>b6</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 183">
        <xsl:text>b7</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 184">
        <xsl:text>b8</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 185">
        <xsl:text>b9</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 186">
        <xsl:text>ba</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 187">
        <xsl:text>bb</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 188">
        <xsl:text>bc</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 189">
        <xsl:text>bd</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 190">
        <xsl:text>be</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 191">
        <xsl:text>bf</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 192">
        <xsl:text>c0</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 193">
        <xsl:text>c1</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 194">
        <xsl:text>c2</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 195">
        <xsl:text>c3</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 196">
        <xsl:text>c4</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 197">
        <xsl:text>c5</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 198">
        <xsl:text>c6</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 199">
        <xsl:text>c7</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 200">
        <xsl:text>c8</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 201">
        <xsl:text>c9</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 202">
        <xsl:text>ca</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 203">
        <xsl:text>cb</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 204">
        <xsl:text>cc</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 205">
        <xsl:text>cd</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 206">
        <xsl:text>ce</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 207">
        <xsl:text>cf</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 208">
        <xsl:text>d0</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 209">
        <xsl:text>d1</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 210">
        <xsl:text>d2</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 211">
        <xsl:text>d3</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 212">
        <xsl:text>d4</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 213">
        <xsl:text>d5</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 214">
        <xsl:text>d6</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 215">
        <xsl:text>d7</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 216">
        <xsl:text>d8</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 217">
        <xsl:text>d9</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 218">
        <xsl:text>da</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 219">
        <xsl:text>db</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 220">
        <xsl:text>dc</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 221">
        <xsl:text>dd</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 222">
        <xsl:text>de</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 223">
        <xsl:text>df</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 224">
        <xsl:text>e0</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 225">
        <xsl:text>e1</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 226">
        <xsl:text>e2</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 227">
        <xsl:text>e3</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 228">
        <xsl:text>e4</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 229">
        <xsl:text>e5</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 230">
        <xsl:text>e6</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 231">
        <xsl:text>e7</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 232">
        <xsl:text>e8</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 233">
        <xsl:text>e9</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 234">
        <xsl:text>ea</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 235">
        <xsl:text>eb</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 236">
        <xsl:text>ec</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 237">
        <xsl:text>ed</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 238">
        <xsl:text>ee</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 239">
        <xsl:text>ef</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 240">
        <xsl:text>f0</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 241">
        <xsl:text>f1</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 242">
        <xsl:text>f2</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 243">
        <xsl:text>f3</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 244">
        <xsl:text>f4</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 245">
        <xsl:text>f5</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 246">
        <xsl:text>f6</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 247">
        <xsl:text>f7</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 248">
        <xsl:text>f8</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 249">
        <xsl:text>f9</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 250">
        <xsl:text>fa</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 251">
        <xsl:text>fb</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 252">
        <xsl:text>fc</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 253">
        <xsl:text>fd</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 254">
        <xsl:text>fe</xsl:text>
      </xsl:when>
      <xsl:when test="$word = 255">
        <xsl:text>ff</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:message>
          <xsl:value-of select="concat('Range error: $word = ', $word, ' (uint8-encode)', $endl)"/>
        </xsl:message>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="uint16-bitwise-and">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:variable name="upper">
      <xsl:call-template name="uint8-bitwise-and">
        <xsl:with-param name="a" select="floor($a div 256)"/>
        <xsl:with-param name="b" select="floor($b div 256)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="lower">
      <xsl:call-template name="uint8-bitwise-and">
        <xsl:with-param name="a" select="$a mod 256"/>
        <xsl:with-param name="b" select="$b mod 256"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="$upper * 256 + $lower"/>
  </xsl:template>
  <xsl:template name="uint16-bitwise-xor">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:variable name="upper">
      <xsl:call-template name="uint8-bitwise-xor">
        <xsl:with-param name="a" select="floor($a div 256)"/>
        <xsl:with-param name="b" select="floor($b div 256)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="lower">
      <xsl:call-template name="uint8-bitwise-xor">
        <xsl:with-param name="a" select="$a mod 256"/>
        <xsl:with-param name="b" select="$b mod 256"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="$upper * 256 + $lower"/>
  </xsl:template>
  <xsl:template name="uint16-bitwise-or">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:variable name="upper">
      <xsl:call-template name="uint8-bitwise-or">
        <xsl:with-param name="a" select="floor($a div 256)"/>
        <xsl:with-param name="b" select="floor($b div 256)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="lower">
      <xsl:call-template name="uint8-bitwise-or">
        <xsl:with-param name="a" select="$a mod 256"/>
        <xsl:with-param name="b" select="$b mod 256"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="$upper * 256 + $lower"/>
  </xsl:template>
  <xsl:template name="uint32-bitwise-and">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:variable name="upper">
      <xsl:call-template name="uint16-bitwise-and">
        <xsl:with-param name="a" select="floor($a div 65536)"/>
        <xsl:with-param name="b" select="floor($b div 65536)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="lower">
      <xsl:call-template name="uint16-bitwise-and">
        <xsl:with-param name="a" select="$a mod 65536"/>
        <xsl:with-param name="b" select="$b mod 65536"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="format-number($upper * 65536 + $lower, '0')"/>
  </xsl:template>
  <xsl:template name="uint32-bitwise-xor">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:variable name="upper">
      <xsl:call-template name="uint16-bitwise-xor">
        <xsl:with-param name="a" select="floor($a div 65536)"/>
        <xsl:with-param name="b" select="floor($b div 65536)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="lower">
      <xsl:call-template name="uint16-bitwise-xor">
        <xsl:with-param name="a" select="$a mod 65536"/>
        <xsl:with-param name="b" select="$b mod 65536"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="format-number($upper * 65536 + $lower, '0')"/>
  </xsl:template>
  <xsl:template name="uint32-bitwise-or">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:variable name="upper">
      <xsl:call-template name="uint16-bitwise-or">
        <xsl:with-param name="a" select="floor($a div 65536)"/>
        <xsl:with-param name="b" select="floor($b div 65536)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="lower">
      <xsl:call-template name="uint16-bitwise-or">
        <xsl:with-param name="a" select="$a mod 65536"/>
        <xsl:with-param name="b" select="$b mod 65536"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="format-number($upper * 65536 + $lower, '0')"/>
  </xsl:template>
  <xsl:template name="uint16-decode">
    <xsl:param name="byte"/>
    <xsl:variable name="upper">
      <xsl:call-template name="uint8-decode">
        <xsl:with-param name="byte" select="substring($byte, 3, 2)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="lower">
      <xsl:call-template name="uint8-decode">
        <xsl:with-param name="byte" select="substring($byte, 1, 2)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="$upper * 256 + $lower"/>
  </xsl:template>
  <xsl:template name="uint16-encode">
    <xsl:param name="word"/>
    <xsl:variable name="upper">
      <xsl:call-template name="uint8-encode">
        <xsl:with-param name="word" select="floor($word div 256)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="lower">
      <xsl:call-template name="uint8-encode">
        <xsl:with-param name="word" select="$word mod 256"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="concat($lower, $upper)"/>
  </xsl:template>
  <xsl:template name="uint32-decode">
    <xsl:param name="byte"/>
    <xsl:variable name="upper">
      <xsl:call-template name="uint16-decode">
        <xsl:with-param name="byte" select="substring($byte, 5, 4)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="lower">
      <xsl:call-template name="uint16-decode">
        <xsl:with-param name="byte" select="substring($byte, 1, 4)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="format-number($upper * 65536 + $lower, '0')"/>
  </xsl:template>
  <xsl:template name="uint32-encode">
    <xsl:param name="word"/>
    <xsl:variable name="upper">
      <xsl:call-template name="uint16-encode">
        <xsl:with-param name="word" select="floor($word div 65536)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="lower">
      <xsl:call-template name="uint16-encode">
        <xsl:with-param name="word" select="$word mod 65536"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="concat($lower, $upper)"/>
  </xsl:template>
  <xsl:template name="uint32-bitwise-not">
    <xsl:param name="a"/>
    <xsl:value-of select="format-number(4294967295 - $a, '0')"/>
  </xsl:template>
  <xsl:template name="uint32-left-shift-n">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:choose>
      <xsl:when test="$b = 0">
        <xsl:value-of select="$a"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="uint32-left-shift-n">
          <xsl:with-param name="a" select="format-number($a * 2 mod 4294967296, '0')"/>
          <xsl:with-param name="b" select="$b - 1"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="uint32-right-shift-n">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:choose>
      <xsl:when test="$b = 0">
        <xsl:value-of select="$a"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="uint32-right-shift-n">
          <xsl:with-param name="a" select="format-number(floor($a div 2), '0')"/>
          <xsl:with-param name="b" select="$b - 1"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="uint32-add">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:param name="carry"/>
    <xsl:value-of select="format-number(($a + $b) mod 4294967296, '0')"/>
    <xsl:if test="$carry">
      <xsl:value-of select="concat(';', format-number(floor(($a + $b) div 4294967296), '0'), ';')"/>
    </xsl:if>
  </xsl:template>
  <xsl:template name="uint64-encode">
    <xsl:param name="word"/>
    <xsl:variable name="upper">
      <xsl:call-template name="uint32-encode">
        <xsl:with-param name="word" select="substring-before($word, ',,')"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="lower">
      <xsl:call-template name="uint32-encode">
        <xsl:with-param name="word" select="substring-after($word, ',,')"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="concat($lower, $upper)"/>
  </xsl:template>
  <xsl:template name="uint64-add-n">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:variable name="lower">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a" select="substring-after($a, ',,')"/>
        <xsl:with-param name="b" select="$b"/>
        <xsl:with-param name="carry" select="1"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="upper">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a" select="substring-before($a, ',,')"/>
        <xsl:with-param name="b" select="substring-before(substring-after($lower, ';'), ';')"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="concat($upper, ',,', substring-before($lower, ';'))"/>
  </xsl:template>
  <xsl:template name="string-encode">
    <xsl:param name="string"/>
    <xsl:param name="i" select="1"/>
    <xsl:param name="n" select="string-length($string)"/>
    <xsl:choose>
      <xsl:when test="$n = 0"/>
      <xsl:when test="$n = 1">
        <xsl:for-each select="document('vaporoid-hash-char-encode-1.xml')">
          <xsl:variable name="byte1" select="key('vaporoid-hash-table', substring($string, $i, 1))"/>
          <xsl:choose>
            <xsl:when test="boolean($byte1)">
              <xsl:value-of select="$byte1"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:for-each select="document('vaporoid-hash-char-encode-2.xml')">
                <xsl:variable name="byte2" select="key('vaporoid-hash-table', substring($string, $i, 1))"/>
                <xsl:choose>
                  <xsl:when test="boolean($byte2)">
                    <xsl:value-of select="$byte2"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:for-each select="document('vaporoid-hash-char-encode-3.xml')">
                      <xsl:variable name="byte3" select="key('vaporoid-hash-table', substring($string, $i, 1))"/>
                      <xsl:choose>
                        <xsl:when test="boolean($byte3)">
                          <xsl:value-of select="$byte3"/>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:message>Unknown char</xsl:message>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:for-each>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:for-each>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="m" select="floor($n div 2)"/>
        <xsl:call-template name="string-encode">
          <xsl:with-param name="string" select="$string"/>
          <xsl:with-param name="i" select="$i"/>
          <xsl:with-param name="n" select="$m"/>
        </xsl:call-template>
        <xsl:call-template name="string-encode">
          <xsl:with-param name="string" select="$string"/>
          <xsl:with-param name="i" select="$i + $m"/>
          <xsl:with-param name="n" select="$n - $m"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="string-add">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:param name="c"/>
    <xsl:param name="d"/>
    <xsl:value-of select="concat($a, $b, $c, $d)"/>
  </xsl:template>
  <xsl:template name="string-fill">
    <xsl:param name="char"/>
    <xsl:param name="n"/>
    <xsl:choose>
      <xsl:when test="$n = 0"/>
      <xsl:when test="$n = 1">
        <xsl:value-of select="$char"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="m" select="floor($n div 2)"/>
        <xsl:call-template name="string-fill">
          <xsl:with-param name="char" select="$char"/>
          <xsl:with-param name="n" select="$m"/>
        </xsl:call-template>
        <xsl:call-template name="string-fill">
          <xsl:with-param name="char" select="$char"/>
          <xsl:with-param name="n" select="$n - $m"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="md5-f">
    <xsl:param name="x"/>
    <xsl:param name="y"/>
    <xsl:param name="z"/>
    <xsl:call-template name="uint32-bitwise-or">
      <xsl:with-param name="a">
        <xsl:call-template name="uint32-bitwise-and">
          <xsl:with-param name="a">
            <xsl:value-of select="$x"/>
          </xsl:with-param>
          <xsl:with-param name="b">
            <xsl:value-of select="$y"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
      <xsl:with-param name="b">
        <xsl:call-template name="uint32-bitwise-and">
          <xsl:with-param name="a">
            <xsl:call-template name="uint32-bitwise-not">
              <xsl:with-param name="a">
                <xsl:value-of select="$x"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:with-param>
          <xsl:with-param name="b">
            <xsl:value-of select="$z"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="md5-g">
    <xsl:param name="x"/>
    <xsl:param name="y"/>
    <xsl:param name="z"/>
    <xsl:call-template name="uint32-bitwise-or">
      <xsl:with-param name="a">
        <xsl:call-template name="uint32-bitwise-and">
          <xsl:with-param name="a">
            <xsl:value-of select="$x"/>
          </xsl:with-param>
          <xsl:with-param name="b">
            <xsl:value-of select="$z"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
      <xsl:with-param name="b">
        <xsl:call-template name="uint32-bitwise-and">
          <xsl:with-param name="a">
            <xsl:value-of select="$y"/>
          </xsl:with-param>
          <xsl:with-param name="b">
            <xsl:call-template name="uint32-bitwise-not">
              <xsl:with-param name="a">
                <xsl:value-of select="$z"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="md5-h">
    <xsl:param name="x"/>
    <xsl:param name="y"/>
    <xsl:param name="z"/>
    <xsl:call-template name="uint32-bitwise-xor">
      <xsl:with-param name="a">
        <xsl:call-template name="uint32-bitwise-xor">
          <xsl:with-param name="a">
            <xsl:value-of select="$x"/>
          </xsl:with-param>
          <xsl:with-param name="b">
            <xsl:value-of select="$y"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
      <xsl:with-param name="b">
        <xsl:value-of select="$z"/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="md5-i">
    <xsl:param name="x"/>
    <xsl:param name="y"/>
    <xsl:param name="z"/>
    <xsl:call-template name="uint32-bitwise-xor">
      <xsl:with-param name="a">
        <xsl:value-of select="$y"/>
      </xsl:with-param>
      <xsl:with-param name="b">
        <xsl:call-template name="uint32-bitwise-or">
          <xsl:with-param name="a">
            <xsl:value-of select="$x"/>
          </xsl:with-param>
          <xsl:with-param name="b">
            <xsl:call-template name="uint32-bitwise-not">
              <xsl:with-param name="a">
                <xsl:value-of select="$z"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="md5-rotate-left">
    <xsl:param name="x"/>
    <xsl:param name="n"/>
    <xsl:call-template name="uint32-bitwise-or">
      <xsl:with-param name="a">
        <xsl:call-template name="uint32-left-shift-n">
          <xsl:with-param name="a">
            <xsl:value-of select="$x"/>
          </xsl:with-param>
          <xsl:with-param name="b">
            <xsl:value-of select="$n"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
      <xsl:with-param name="b">
        <xsl:call-template name="uint32-right-shift-n">
          <xsl:with-param name="a">
            <xsl:value-of select="$x"/>
          </xsl:with-param>
          <xsl:with-param name="b">
            <xsl:value-of select="32 - $n"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="md5-ff">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:param name="c"/>
    <xsl:param name="d"/>
    <xsl:param name="x"/>
    <xsl:param name="s"/>
    <xsl:param name="ac"/>
    <xsl:variable name="_0">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a">
          <xsl:value-of select="$a"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:call-template name="md5-f">
            <xsl:with-param name="x">
              <xsl:value-of select="$b"/>
            </xsl:with-param>
            <xsl:with-param name="y">
              <xsl:value-of select="$c"/>
            </xsl:with-param>
            <xsl:with-param name="z">
              <xsl:value-of select="$d"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_1">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a">
          <xsl:value-of select="$_0"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$x"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_2">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a">
          <xsl:value-of select="$_1"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$ac"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_3">
      <xsl:call-template name="md5-rotate-left">
        <xsl:with-param name="x">
          <xsl:value-of select="$_2"/>
        </xsl:with-param>
        <xsl:with-param name="n">
          <xsl:value-of select="$s"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:call-template name="uint32-add">
      <xsl:with-param name="a">
        <xsl:value-of select="$_3"/>
      </xsl:with-param>
      <xsl:with-param name="b">
        <xsl:value-of select="$b"/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="md5-gg">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:param name="c"/>
    <xsl:param name="d"/>
    <xsl:param name="x"/>
    <xsl:param name="s"/>
    <xsl:param name="ac"/>
    <xsl:variable name="_0">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a">
          <xsl:value-of select="$a"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:call-template name="md5-g">
            <xsl:with-param name="x">
              <xsl:value-of select="$b"/>
            </xsl:with-param>
            <xsl:with-param name="y">
              <xsl:value-of select="$c"/>
            </xsl:with-param>
            <xsl:with-param name="z">
              <xsl:value-of select="$d"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_1">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a">
          <xsl:value-of select="$_0"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$x"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_2">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a">
          <xsl:value-of select="$_1"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$ac"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_3">
      <xsl:call-template name="md5-rotate-left">
        <xsl:with-param name="x">
          <xsl:value-of select="$_2"/>
        </xsl:with-param>
        <xsl:with-param name="n">
          <xsl:value-of select="$s"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:call-template name="uint32-add">
      <xsl:with-param name="a">
        <xsl:value-of select="$_3"/>
      </xsl:with-param>
      <xsl:with-param name="b">
        <xsl:value-of select="$b"/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="md5-hh">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:param name="c"/>
    <xsl:param name="d"/>
    <xsl:param name="x"/>
    <xsl:param name="s"/>
    <xsl:param name="ac"/>
    <xsl:variable name="_0">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a">
          <xsl:value-of select="$a"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:call-template name="md5-h">
            <xsl:with-param name="x">
              <xsl:value-of select="$b"/>
            </xsl:with-param>
            <xsl:with-param name="y">
              <xsl:value-of select="$c"/>
            </xsl:with-param>
            <xsl:with-param name="z">
              <xsl:value-of select="$d"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_1">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a">
          <xsl:value-of select="$_0"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$x"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_2">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a">
          <xsl:value-of select="$_1"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$ac"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_3">
      <xsl:call-template name="md5-rotate-left">
        <xsl:with-param name="x">
          <xsl:value-of select="$_2"/>
        </xsl:with-param>
        <xsl:with-param name="n">
          <xsl:value-of select="$s"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:call-template name="uint32-add">
      <xsl:with-param name="a">
        <xsl:value-of select="$_3"/>
      </xsl:with-param>
      <xsl:with-param name="b">
        <xsl:value-of select="$b"/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="md5-ii">
    <xsl:param name="a"/>
    <xsl:param name="b"/>
    <xsl:param name="c"/>
    <xsl:param name="d"/>
    <xsl:param name="x"/>
    <xsl:param name="s"/>
    <xsl:param name="ac"/>
    <xsl:variable name="_0">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a">
          <xsl:value-of select="$a"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:call-template name="md5-i">
            <xsl:with-param name="x">
              <xsl:value-of select="$b"/>
            </xsl:with-param>
            <xsl:with-param name="y">
              <xsl:value-of select="$c"/>
            </xsl:with-param>
            <xsl:with-param name="z">
              <xsl:value-of select="$d"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_1">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a">
          <xsl:value-of select="$_0"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$x"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_2">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a">
          <xsl:value-of select="$_1"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$ac"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_3">
      <xsl:call-template name="md5-rotate-left">
        <xsl:with-param name="x">
          <xsl:value-of select="$_2"/>
        </xsl:with-param>
        <xsl:with-param name="n">
          <xsl:value-of select="$s"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:call-template name="uint32-add">
      <xsl:with-param name="a">
        <xsl:value-of select="$_3"/>
      </xsl:with-param>
      <xsl:with-param name="b">
        <xsl:value-of select="$b"/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="md5-init">
    <xsl:variable name="_0">
      <xsl:text>1732584193</xsl:text>
    </xsl:variable>
    <xsl:variable name="_1">
      <xsl:text>4023233417</xsl:text>
    </xsl:variable>
    <xsl:variable name="_2">
      <xsl:text>2562383102</xsl:text>
    </xsl:variable>
    <xsl:variable name="_3">
      <xsl:text>271733878</xsl:text>
    </xsl:variable>
    <xsl:value-of select="$_0"/>
    <xsl:text>;</xsl:text>
    <xsl:value-of select="$_1"/>
    <xsl:text>;</xsl:text>
    <xsl:value-of select="$_2"/>
    <xsl:text>;</xsl:text>
    <xsl:value-of select="$_3"/>
    <xsl:text>;</xsl:text>
  </xsl:template>
  <xsl:template name="md5-transform">
    <xsl:param name="state"/>
    <xsl:param name="buffer"/>
    <xsl:param name="offset"/>
    <xsl:variable name="_0">
      <xsl:value-of select="substring-before($state, ';')"/>
    </xsl:variable>
    <xsl:variable name="_1">
      <xsl:value-of select="substring-before(substring-after($state, ';'), ';')"/>
    </xsl:variable>
    <xsl:variable name="_2">
      <xsl:value-of select="substring-before(substring-after(substring-after($state, ';'), ';'), ';')"/>
    </xsl:variable>
    <xsl:variable name="_3">
      <xsl:value-of select="substring-before(substring-after(substring-after(substring-after($state, ';'), ';'), ';'), ';')"/>
    </xsl:variable>
    <xsl:variable name="_4">
      <xsl:call-template name="uint32-decode">
        <xsl:with-param name="byte">
          <xsl:value-of select="substring($buffer,   1 + $offset, 8)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_5">
      <xsl:call-template name="uint32-decode">
        <xsl:with-param name="byte">
          <xsl:value-of select="substring($buffer,   9 + $offset, 8)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_6">
      <xsl:call-template name="uint32-decode">
        <xsl:with-param name="byte">
          <xsl:value-of select="substring($buffer,  17 + $offset, 8)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_7">
      <xsl:call-template name="uint32-decode">
        <xsl:with-param name="byte">
          <xsl:value-of select="substring($buffer,  25 + $offset, 8)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_8">
      <xsl:call-template name="uint32-decode">
        <xsl:with-param name="byte">
          <xsl:value-of select="substring($buffer,  33 + $offset, 8)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_9">
      <xsl:call-template name="uint32-decode">
        <xsl:with-param name="byte">
          <xsl:value-of select="substring($buffer,  41 + $offset, 8)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_10">
      <xsl:call-template name="uint32-decode">
        <xsl:with-param name="byte">
          <xsl:value-of select="substring($buffer,  49 + $offset, 8)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_11">
      <xsl:call-template name="uint32-decode">
        <xsl:with-param name="byte">
          <xsl:value-of select="substring($buffer,  57 + $offset, 8)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_12">
      <xsl:call-template name="uint32-decode">
        <xsl:with-param name="byte">
          <xsl:value-of select="substring($buffer,  65 + $offset, 8)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_13">
      <xsl:call-template name="uint32-decode">
        <xsl:with-param name="byte">
          <xsl:value-of select="substring($buffer,  73 + $offset, 8)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_14">
      <xsl:call-template name="uint32-decode">
        <xsl:with-param name="byte">
          <xsl:value-of select="substring($buffer,  81 + $offset, 8)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_15">
      <xsl:call-template name="uint32-decode">
        <xsl:with-param name="byte">
          <xsl:value-of select="substring($buffer,  89 + $offset, 8)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_16">
      <xsl:call-template name="uint32-decode">
        <xsl:with-param name="byte">
          <xsl:value-of select="substring($buffer,  97 + $offset, 8)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_17">
      <xsl:call-template name="uint32-decode">
        <xsl:with-param name="byte">
          <xsl:value-of select="substring($buffer, 105 + $offset, 8)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_18">
      <xsl:call-template name="uint32-decode">
        <xsl:with-param name="byte">
          <xsl:value-of select="substring($buffer, 113 + $offset, 8)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_19">
      <xsl:call-template name="uint32-decode">
        <xsl:with-param name="byte">
          <xsl:value-of select="substring($buffer, 121 + $offset, 8)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_20">
      <xsl:call-template name="md5-ff">
        <xsl:with-param name="a">
          <xsl:value-of select="$_0"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_1"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_2"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_3"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_4"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>7</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3614090360</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_21">
      <xsl:call-template name="md5-ff">
        <xsl:with-param name="a">
          <xsl:value-of select="$_3"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_20"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_1"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_2"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_5"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>12</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3905402710</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_22">
      <xsl:call-template name="md5-ff">
        <xsl:with-param name="a">
          <xsl:value-of select="$_2"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_21"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_20"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_1"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_6"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>17</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>606105819</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_23">
      <xsl:call-template name="md5-ff">
        <xsl:with-param name="a">
          <xsl:value-of select="$_1"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_22"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_21"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_20"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_7"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>22</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3250441966</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_24">
      <xsl:call-template name="md5-ff">
        <xsl:with-param name="a">
          <xsl:value-of select="$_20"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_23"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_22"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_21"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_8"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>7</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>4118548399</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_25">
      <xsl:call-template name="md5-ff">
        <xsl:with-param name="a">
          <xsl:value-of select="$_21"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_24"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_23"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_22"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_9"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>12</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>1200080426</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_26">
      <xsl:call-template name="md5-ff">
        <xsl:with-param name="a">
          <xsl:value-of select="$_22"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_25"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_24"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_23"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_10"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>17</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>2821735955</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_27">
      <xsl:call-template name="md5-ff">
        <xsl:with-param name="a">
          <xsl:value-of select="$_23"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_26"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_25"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_24"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_11"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>22</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>4249261313</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_28">
      <xsl:call-template name="md5-ff">
        <xsl:with-param name="a">
          <xsl:value-of select="$_24"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_27"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_26"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_25"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_12"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>7</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>1770035416</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_29">
      <xsl:call-template name="md5-ff">
        <xsl:with-param name="a">
          <xsl:value-of select="$_25"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_28"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_27"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_26"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_13"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>12</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>2336552879</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_30">
      <xsl:call-template name="md5-ff">
        <xsl:with-param name="a">
          <xsl:value-of select="$_26"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_29"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_28"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_27"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_14"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>17</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>4294925233</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_31">
      <xsl:call-template name="md5-ff">
        <xsl:with-param name="a">
          <xsl:value-of select="$_27"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_30"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_29"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_28"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_15"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>22</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>2304563134</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_32">
      <xsl:call-template name="md5-ff">
        <xsl:with-param name="a">
          <xsl:value-of select="$_28"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_31"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_30"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_29"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_16"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>7</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>1804603682</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_33">
      <xsl:call-template name="md5-ff">
        <xsl:with-param name="a">
          <xsl:value-of select="$_29"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_32"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_31"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_30"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_17"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>12</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>4254626195</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_34">
      <xsl:call-template name="md5-ff">
        <xsl:with-param name="a">
          <xsl:value-of select="$_30"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_33"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_32"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_31"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_18"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>17</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>2792965006</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_35">
      <xsl:call-template name="md5-ff">
        <xsl:with-param name="a">
          <xsl:value-of select="$_31"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_34"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_33"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_32"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_19"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>22</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>1236535329</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_36">
      <xsl:call-template name="md5-gg">
        <xsl:with-param name="a">
          <xsl:value-of select="$_32"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_35"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_34"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_33"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_5"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>5</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>4129170786</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_37">
      <xsl:call-template name="md5-gg">
        <xsl:with-param name="a">
          <xsl:value-of select="$_33"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_36"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_35"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_34"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_10"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>9</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3225465664</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_38">
      <xsl:call-template name="md5-gg">
        <xsl:with-param name="a">
          <xsl:value-of select="$_34"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_37"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_36"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_35"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_15"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>14</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>643717713</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_39">
      <xsl:call-template name="md5-gg">
        <xsl:with-param name="a">
          <xsl:value-of select="$_35"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_38"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_37"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_36"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_4"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>20</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3921069994</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_40">
      <xsl:call-template name="md5-gg">
        <xsl:with-param name="a">
          <xsl:value-of select="$_36"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_39"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_38"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_37"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_9"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>5</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3593408605</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_41">
      <xsl:call-template name="md5-gg">
        <xsl:with-param name="a">
          <xsl:value-of select="$_37"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_40"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_39"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_38"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_14"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>9</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>38016083</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_42">
      <xsl:call-template name="md5-gg">
        <xsl:with-param name="a">
          <xsl:value-of select="$_38"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_41"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_40"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_39"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_19"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>14</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3634488961</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_43">
      <xsl:call-template name="md5-gg">
        <xsl:with-param name="a">
          <xsl:value-of select="$_39"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_42"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_41"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_40"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_8"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>20</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3889429448</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_44">
      <xsl:call-template name="md5-gg">
        <xsl:with-param name="a">
          <xsl:value-of select="$_40"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_43"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_42"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_41"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_13"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>5</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>568446438</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_45">
      <xsl:call-template name="md5-gg">
        <xsl:with-param name="a">
          <xsl:value-of select="$_41"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_44"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_43"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_42"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_18"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>9</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3275163606</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_46">
      <xsl:call-template name="md5-gg">
        <xsl:with-param name="a">
          <xsl:value-of select="$_42"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_45"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_44"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_43"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_7"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>14</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>4107603335</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_47">
      <xsl:call-template name="md5-gg">
        <xsl:with-param name="a">
          <xsl:value-of select="$_43"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_46"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_45"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_44"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_12"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>20</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>1163531501</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_48">
      <xsl:call-template name="md5-gg">
        <xsl:with-param name="a">
          <xsl:value-of select="$_44"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_47"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_46"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_45"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_17"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>5</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>2850285829</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_49">
      <xsl:call-template name="md5-gg">
        <xsl:with-param name="a">
          <xsl:value-of select="$_45"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_48"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_47"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_46"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_6"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>9</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>4243563512</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_50">
      <xsl:call-template name="md5-gg">
        <xsl:with-param name="a">
          <xsl:value-of select="$_46"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_49"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_48"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_47"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_11"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>14</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>1735328473</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_51">
      <xsl:call-template name="md5-gg">
        <xsl:with-param name="a">
          <xsl:value-of select="$_47"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_50"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_49"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_48"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_16"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>20</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>2368359562</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_52">
      <xsl:call-template name="md5-hh">
        <xsl:with-param name="a">
          <xsl:value-of select="$_48"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_51"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_50"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_49"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_9"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>4</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>4294588738</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_53">
      <xsl:call-template name="md5-hh">
        <xsl:with-param name="a">
          <xsl:value-of select="$_49"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_52"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_51"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_50"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_12"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>11</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>2272392833</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_54">
      <xsl:call-template name="md5-hh">
        <xsl:with-param name="a">
          <xsl:value-of select="$_50"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_53"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_52"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_51"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_15"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>16</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>1839030562</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_55">
      <xsl:call-template name="md5-hh">
        <xsl:with-param name="a">
          <xsl:value-of select="$_51"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_54"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_53"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_52"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_18"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>23</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>4259657740</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_56">
      <xsl:call-template name="md5-hh">
        <xsl:with-param name="a">
          <xsl:value-of select="$_52"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_55"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_54"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_53"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_5"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>4</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>2763975236</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_57">
      <xsl:call-template name="md5-hh">
        <xsl:with-param name="a">
          <xsl:value-of select="$_53"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_56"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_55"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_54"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_8"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>11</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>1272893353</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_58">
      <xsl:call-template name="md5-hh">
        <xsl:with-param name="a">
          <xsl:value-of select="$_54"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_57"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_56"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_55"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_11"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>16</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>4139469664</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_59">
      <xsl:call-template name="md5-hh">
        <xsl:with-param name="a">
          <xsl:value-of select="$_55"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_58"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_57"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_56"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_14"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>23</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3200236656</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_60">
      <xsl:call-template name="md5-hh">
        <xsl:with-param name="a">
          <xsl:value-of select="$_56"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_59"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_58"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_57"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_17"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>4</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>681279174</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_61">
      <xsl:call-template name="md5-hh">
        <xsl:with-param name="a">
          <xsl:value-of select="$_57"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_60"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_59"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_58"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_4"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>11</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3936430074</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_62">
      <xsl:call-template name="md5-hh">
        <xsl:with-param name="a">
          <xsl:value-of select="$_58"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_61"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_60"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_59"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_7"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>16</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3572445317</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_63">
      <xsl:call-template name="md5-hh">
        <xsl:with-param name="a">
          <xsl:value-of select="$_59"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_62"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_61"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_60"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_10"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>23</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>76029189</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_64">
      <xsl:call-template name="md5-hh">
        <xsl:with-param name="a">
          <xsl:value-of select="$_60"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_63"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_62"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_61"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_13"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>4</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3654602809</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_65">
      <xsl:call-template name="md5-hh">
        <xsl:with-param name="a">
          <xsl:value-of select="$_61"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_64"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_63"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_62"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_16"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>11</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3873151461</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_66">
      <xsl:call-template name="md5-hh">
        <xsl:with-param name="a">
          <xsl:value-of select="$_62"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_65"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_64"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_63"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_19"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>16</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>530742520</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_67">
      <xsl:call-template name="md5-hh">
        <xsl:with-param name="a">
          <xsl:value-of select="$_63"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_66"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_65"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_64"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_6"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>23</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3299628645</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_68">
      <xsl:call-template name="md5-ii">
        <xsl:with-param name="a">
          <xsl:value-of select="$_64"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_67"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_66"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_65"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_4"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>6</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>4096336452</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_69">
      <xsl:call-template name="md5-ii">
        <xsl:with-param name="a">
          <xsl:value-of select="$_65"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_68"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_67"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_66"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_11"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>10</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>1126891415</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_70">
      <xsl:call-template name="md5-ii">
        <xsl:with-param name="a">
          <xsl:value-of select="$_66"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_69"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_68"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_67"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_18"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>15</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>2878612391</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_71">
      <xsl:call-template name="md5-ii">
        <xsl:with-param name="a">
          <xsl:value-of select="$_67"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_70"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_69"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_68"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_9"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>21</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>4237533241</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_72">
      <xsl:call-template name="md5-ii">
        <xsl:with-param name="a">
          <xsl:value-of select="$_68"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_71"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_70"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_69"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_16"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>6</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>1700485571</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_73">
      <xsl:call-template name="md5-ii">
        <xsl:with-param name="a">
          <xsl:value-of select="$_69"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_72"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_71"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_70"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_7"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>10</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>2399980690</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_74">
      <xsl:call-template name="md5-ii">
        <xsl:with-param name="a">
          <xsl:value-of select="$_70"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_73"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_72"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_71"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_14"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>15</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>4293915773</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_75">
      <xsl:call-template name="md5-ii">
        <xsl:with-param name="a">
          <xsl:value-of select="$_71"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_74"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_73"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_72"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_5"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>21</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>2240044497</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_76">
      <xsl:call-template name="md5-ii">
        <xsl:with-param name="a">
          <xsl:value-of select="$_72"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_75"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_74"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_73"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_12"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>6</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>1873313359</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_77">
      <xsl:call-template name="md5-ii">
        <xsl:with-param name="a">
          <xsl:value-of select="$_73"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_76"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_75"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_74"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_19"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>10</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>4264355552</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_78">
      <xsl:call-template name="md5-ii">
        <xsl:with-param name="a">
          <xsl:value-of select="$_74"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_77"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_76"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_75"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_10"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>15</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>2734768916</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_79">
      <xsl:call-template name="md5-ii">
        <xsl:with-param name="a">
          <xsl:value-of select="$_75"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_78"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_77"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_76"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_17"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>21</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>1309151649</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_80">
      <xsl:call-template name="md5-ii">
        <xsl:with-param name="a">
          <xsl:value-of select="$_76"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_79"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_78"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_77"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_8"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>6</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>4149444226</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_81">
      <xsl:call-template name="md5-ii">
        <xsl:with-param name="a">
          <xsl:value-of select="$_77"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_80"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_79"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_78"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_15"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>10</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3174756917</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_82">
      <xsl:call-template name="md5-ii">
        <xsl:with-param name="a">
          <xsl:value-of select="$_78"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_81"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_80"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_79"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_6"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>15</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>718787259</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_83">
      <xsl:call-template name="md5-ii">
        <xsl:with-param name="a">
          <xsl:value-of select="$_79"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_82"/>
        </xsl:with-param>
        <xsl:with-param name="c">
          <xsl:value-of select="$_81"/>
        </xsl:with-param>
        <xsl:with-param name="d">
          <xsl:value-of select="$_80"/>
        </xsl:with-param>
        <xsl:with-param name="x">
          <xsl:value-of select="$_13"/>
        </xsl:with-param>
        <xsl:with-param name="s">
          <xsl:text>21</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="ac">
          <xsl:text>3951481745</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_84">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a">
          <xsl:value-of select="substring-before($state, ';')"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_80"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_85">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a">
          <xsl:value-of select="substring-before(substring-after($state, ';'), ';')"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_83"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_86">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a">
          <xsl:value-of select="substring-before(substring-after(substring-after($state, ';'), ';'), ';')"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_82"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="_87">
      <xsl:call-template name="uint32-add">
        <xsl:with-param name="a">
          <xsl:value-of select="substring-before(substring-after(substring-after(substring-after($state, ';'), ';'), ';'), ';')"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="$_81"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="$_84"/>
    <xsl:text>;</xsl:text>
    <xsl:value-of select="$_85"/>
    <xsl:text>;</xsl:text>
    <xsl:value-of select="$_86"/>
    <xsl:text>;</xsl:text>
    <xsl:value-of select="$_87"/>
    <xsl:text>;</xsl:text>
  </xsl:template>
  <xsl:template name="md5-encode">
    <xsl:param name="state"/>
    <xsl:variable name="_0">
      <xsl:value-of select="substring-before($state, ';')"/>
    </xsl:variable>
    <xsl:variable name="_1">
      <xsl:value-of select="substring-before(substring-after($state, ';'), ';')"/>
    </xsl:variable>
    <xsl:variable name="_2">
      <xsl:value-of select="substring-before(substring-after(substring-after($state, ';'), ';'), ';')"/>
    </xsl:variable>
    <xsl:variable name="_3">
      <xsl:value-of select="substring-before(substring-after(substring-after(substring-after($state, ';'), ';'), ';'), ';')"/>
    </xsl:variable>
    <xsl:call-template name="uint32-encode">
      <xsl:with-param name="word">
        <xsl:value-of select="$_0"/>
      </xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="uint32-encode">
      <xsl:with-param name="word">
        <xsl:value-of select="$_1"/>
      </xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="uint32-encode">
      <xsl:with-param name="word">
        <xsl:value-of select="$_2"/>
      </xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="uint32-encode">
      <xsl:with-param name="word">
        <xsl:value-of select="$_3"/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="md5-update">
    <xsl:param name="state"/>
    <xsl:param name="buffer"/>
    <xsl:param name="offset"/>
    <xsl:variable name="_0">
      <xsl:value-of select="string-length($buffer) - $offset"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$_0 != 0">
        <xsl:variable name="_1">
          <xsl:call-template name="md5-transform">
            <xsl:with-param name="state">
              <xsl:value-of select="$state"/>
            </xsl:with-param>
            <xsl:with-param name="buffer">
              <xsl:value-of select="$buffer"/>
            </xsl:with-param>
            <xsl:with-param name="offset">
              <xsl:value-of select="$offset"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:variable>
        <xsl:call-template name="md5-update">
          <xsl:with-param name="state">
            <xsl:value-of select="$_1"/>
          </xsl:with-param>
          <xsl:with-param name="buffer">
            <xsl:value-of select="$buffer"/>
          </xsl:with-param>
          <xsl:with-param name="offset">
            <xsl:value-of select="$offset + 128"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="md5-encode">
          <xsl:with-param name="state">
            <xsl:value-of select="$state"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="md5-byte">
    <xsl:param name="state"/>
    <xsl:param name="byte"/>
    <xsl:variable name="_0">
      <xsl:value-of select="string-length($byte) * 4"/>
    </xsl:variable>
    <xsl:variable name="_1">
      <xsl:call-template name="string-add">
        <xsl:with-param name="a">
          <xsl:call-template name="uint32-encode">
            <xsl:with-param name="word">
              <xsl:value-of select="$_0"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="'00000000'"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="mod">
      <xsl:value-of select="string-length($byte) mod 128"/>
    </xsl:variable>
    <xsl:variable name="_2">
      <xsl:value-of select="number($mod &lt;= 110)"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$_2 != 0">
        <xsl:variable name="_3">
          <xsl:call-template name="string-add">
            <xsl:with-param name="a">
              <xsl:value-of select="$byte"/>
            </xsl:with-param>
            <xsl:with-param name="b">
              <xsl:value-of select="'80'"/>
            </xsl:with-param>
            <xsl:with-param name="c">
              <xsl:call-template name="string-fill">
                <xsl:with-param name="char">
                  <xsl:value-of select="'0'"/>
                </xsl:with-param>
                <xsl:with-param name="n">
                  <xsl:value-of select="110 - $mod"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="d">
              <xsl:value-of select="$_1"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:variable>
        <xsl:call-template name="md5-update">
          <xsl:with-param name="state">
            <xsl:value-of select="$state"/>
          </xsl:with-param>
          <xsl:with-param name="buffer">
            <xsl:value-of select="$_3"/>
          </xsl:with-param>
          <xsl:with-param name="offset">
            <xsl:value-of select="0"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="_4">
          <xsl:call-template name="string-add">
            <xsl:with-param name="a">
              <xsl:value-of select="$byte"/>
            </xsl:with-param>
            <xsl:with-param name="b">
              <xsl:value-of select="'80'"/>
            </xsl:with-param>
            <xsl:with-param name="c">
              <xsl:call-template name="string-fill">
                <xsl:with-param name="char">
                  <xsl:value-of select="'0'"/>
                </xsl:with-param>
                <xsl:with-param name="n">
                  <xsl:value-of select="238 - $mod"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="d">
              <xsl:value-of select="$_1"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:variable>
        <xsl:call-template name="md5-update">
          <xsl:with-param name="state">
            <xsl:value-of select="$state"/>
          </xsl:with-param>
          <xsl:with-param name="buffer">
            <xsl:value-of select="$_4"/>
          </xsl:with-param>
          <xsl:with-param name="offset">
            <xsl:value-of select="0"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="md5-string">
    <xsl:param name="state"/>
    <xsl:param name="string"/>
    <xsl:call-template name="md5-byte">
      <xsl:with-param name="state">
        <xsl:value-of select="$state"/>
      </xsl:with-param>
      <xsl:with-param name="byte">
        <xsl:call-template name="string-encode">
          <xsl:with-param name="string">
            <xsl:value-of select="$string"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="md5-byte-3">
    <xsl:param name="state"/>
    <xsl:param name="byte"/>
    <xsl:param name="size"/>
    <xsl:variable name="_0">
      <xsl:value-of select="string-length($byte) * 4 + $size"/>
    </xsl:variable>
    <xsl:variable name="_1">
      <xsl:call-template name="string-add">
        <xsl:with-param name="a">
          <xsl:call-template name="uint32-encode">
            <xsl:with-param name="word">
              <xsl:value-of select="$_0"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:value-of select="'00000000'"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="mod">
      <xsl:value-of select="string-length($byte) mod 128"/>
    </xsl:variable>
    <xsl:variable name="_2">
      <xsl:value-of select="number($mod &lt;= 110)"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$_2 != 0">
        <xsl:variable name="_3">
          <xsl:call-template name="string-add">
            <xsl:with-param name="a">
              <xsl:value-of select="$byte"/>
            </xsl:with-param>
            <xsl:with-param name="b">
              <xsl:value-of select="'80'"/>
            </xsl:with-param>
            <xsl:with-param name="c">
              <xsl:call-template name="string-fill">
                <xsl:with-param name="char">
                  <xsl:value-of select="'0'"/>
                </xsl:with-param>
                <xsl:with-param name="n">
                  <xsl:value-of select="110 - $mod"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="d">
              <xsl:value-of select="$_1"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:variable>
        <xsl:call-template name="md5-update">
          <xsl:with-param name="state">
            <xsl:value-of select="$state"/>
          </xsl:with-param>
          <xsl:with-param name="buffer">
            <xsl:value-of select="$_3"/>
          </xsl:with-param>
          <xsl:with-param name="offset">
            <xsl:value-of select="0"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="_4">
          <xsl:call-template name="string-add">
            <xsl:with-param name="a">
              <xsl:value-of select="$byte"/>
            </xsl:with-param>
            <xsl:with-param name="b">
              <xsl:value-of select="'80'"/>
            </xsl:with-param>
            <xsl:with-param name="c">
              <xsl:call-template name="string-fill">
                <xsl:with-param name="char">
                  <xsl:value-of select="'0'"/>
                </xsl:with-param>
                <xsl:with-param name="n">
                  <xsl:value-of select="238 - $mod"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="d">
              <xsl:value-of select="$_1"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:variable>
        <xsl:call-template name="md5-update">
          <xsl:with-param name="state">
            <xsl:value-of select="$state"/>
          </xsl:with-param>
          <xsl:with-param name="buffer">
            <xsl:value-of select="$_4"/>
          </xsl:with-param>
          <xsl:with-param name="offset">
            <xsl:value-of select="0"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="md5-byte-2">
    <xsl:param name="state"/>
    <xsl:param name="string"/>
    <xsl:param name="i"/>
    <xsl:param name="byte"/>
    <xsl:param name="size"/>
    <xsl:variable name="_0">
      <xsl:value-of select="number(string-length($byte) &gt;= 128)"/>
    </xsl:variable>
    <xsl:variable name="_1">
      <xsl:value-of select="number(string-length($string) = $i)"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$_0 != 0">
        <xsl:variable name="_2">
          <xsl:call-template name="md5-transform">
            <xsl:with-param name="state">
              <xsl:value-of select="$state"/>
            </xsl:with-param>
            <xsl:with-param name="buffer">
              <xsl:value-of select="$byte"/>
            </xsl:with-param>
            <xsl:with-param name="offset">
              <xsl:value-of select="0"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:variable>
        <xsl:call-template name="md5-byte-2">
          <xsl:with-param name="state">
            <xsl:value-of select="$_2"/>
          </xsl:with-param>
          <xsl:with-param name="string">
            <xsl:value-of select="$string"/>
          </xsl:with-param>
          <xsl:with-param name="i">
            <xsl:value-of select="$i"/>
          </xsl:with-param>
          <xsl:with-param name="byte">
            <xsl:value-of select="substring($byte, 129)"/>
          </xsl:with-param>
          <xsl:with-param name="size">
            <xsl:value-of select="$size + 512"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="$_1 != 0">
            <xsl:call-template name="md5-byte-3">
              <xsl:with-param name="state">
                <xsl:value-of select="$state"/>
              </xsl:with-param>
              <xsl:with-param name="byte">
                <xsl:value-of select="$byte"/>
              </xsl:with-param>
              <xsl:with-param name="size">
                <xsl:value-of select="$size"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="md5-string-2">
              <xsl:with-param name="state">
                <xsl:value-of select="$state"/>
              </xsl:with-param>
              <xsl:with-param name="string">
                <xsl:value-of select="$string"/>
              </xsl:with-param>
              <xsl:with-param name="i">
                <xsl:value-of select="$i"/>
              </xsl:with-param>
              <xsl:with-param name="byte">
                <xsl:value-of select="$byte"/>
              </xsl:with-param>
              <xsl:with-param name="size">
                <xsl:value-of select="$size"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="md5-string-2">
    <xsl:param name="state"/>
    <xsl:param name="string"/>
    <xsl:param name="i"/>
    <xsl:param name="byte"/>
    <xsl:param name="size"/>
    <xsl:variable name="size1">
      <xsl:value-of select="string-length($string) - $i"/>
    </xsl:variable>
    <xsl:variable name="size2">
      <xsl:value-of select="number(floor($size1 div 512) != 0) * 512 + number(floor($size1 div 512) = 0) * ($size1 mod 512)"/>
    </xsl:variable>
    <xsl:variable name="_0">
      <xsl:call-template name="string-add">
        <xsl:with-param name="a">
          <xsl:value-of select="$byte"/>
        </xsl:with-param>
        <xsl:with-param name="b">
          <xsl:call-template name="string-encode">
            <xsl:with-param name="string">
              <xsl:value-of select="$string"/>
            </xsl:with-param>
            <xsl:with-param name="i">
              <xsl:value-of select="$i + 1"/>
            </xsl:with-param>
            <xsl:with-param name="n">
              <xsl:value-of select="$size2"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:call-template name="md5-byte-2">
      <xsl:with-param name="state">
        <xsl:value-of select="$state"/>
      </xsl:with-param>
      <xsl:with-param name="string">
        <xsl:value-of select="$string"/>
      </xsl:with-param>
      <xsl:with-param name="i">
        <xsl:value-of select="$i + $size2"/>
      </xsl:with-param>
      <xsl:with-param name="byte">
        <xsl:value-of select="$_0"/>
      </xsl:with-param>
      <xsl:with-param name="size">
        <xsl:value-of select="$size"/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template xmlns:vaporoid-hash="http://vaporoid.com/vaporoid-hash" name="vaporoid-hash:md5">
    <xsl:param name="string"/>
    <xsl:param name="byte"/>
    <xsl:choose>
      <xsl:when test="$string">
        <xsl:call-template name="md5-string-2">
          <xsl:with-param name="state">
            <xsl:call-template name="md5-init"/>
          </xsl:with-param>
          <xsl:with-param name="string" select="$string"/>
          <xsl:with-param name="i" select="0"/>
          <xsl:with-param name="size" select="0"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="md5-byte">
          <xsl:with-param name="state">
            <xsl:call-template name="md5-init"/>
          </xsl:with-param>
          <xsl:with-param name="byte" select="$byte"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
