<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>

<xsl:import href="vptw2cap.xsl"/>

<xsl:output method="text"/>

<xsl:param name="fn" select="'test-timeplus.xml'"/>

<xsl:template match="/">
  <xsl:apply-templates name="*/test"/>
</xsl:template>

<xsl:template match="test">
  <xsl:variable name="r">
    <xsl:call-template name="datetime_add">
      <xsl:with-param name="t" select="t/text()"/>
      <xsl:with-param name="dt" select="dt/text()"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:choose>
  <xsl:when test="$r != r/text()">
    <xsl:message terminate="yes">
      <xsl:value-of
      select="concat($fn,':', position() div 2 + 1,': [',t,'] + [',dt,'] = [',$r,'] != [',r,']')"/>
    </xsl:message>
  </xsl:when>
  <xsl:otherwise />
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
