<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns="http://www.w3.org/2005/Atom"
  xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"
  xmlns:date="http://exslt.org/dates-and-times"
  extension-element-prefixes="date"
  exclude-result-prefixes="date cap"
>

<xsl:param name="files"/>
<xsl:param name="url"/>
<xsl:param name="now"/>

<xsl:output method="xml" version="1.0" encoding="UTF-8"
  omit-xml-declaration="no" indent="yes"/>

<xsl:template match="/">
  <xsl:if test="$files = ''">
    <xsl:message terminate="yes"
    >Error: give me parameter files=&quot;a.cap b.cap ...&quot;</xsl:message>
  </xsl:if>
  <xsl:if test="$url = ''">
    <xsl:message terminate="yes">Error: give me parameter url</xsl:message>
  </xsl:if>
  <feed>
    <xsl:variable name="updated">
      <xsl:choose>
      <xsl:when test="function-available('date:date-time')">
        <xsl:value-of select="date:date-time()"/>
      </xsl:when>
      <xsl:when test="$now != ''">
        <xsl:value-of select="$now"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:message terminate="yes">Error: give me parameter now</xsl:message>
      </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <updated><xsl:value-of select="$updated"/></updated>
    <title>Typhoon Advisories from RSMC Tokyo</title>
    <link rel="self" href="{$url}"/>
    <id><xsl:value-of select="$url"/></id>
    <author>
      <name>RSMC Tokyo - Typhoon Centre</name>
    </author>
    <xsl:call-template name="listchain">
      <xsl:with-param name="list" select="normalize-space($files)"/>
    </xsl:call-template>
  </feed>
</xsl:template>

<xsl:template name="listchain">
  <xsl:param name="list"/>
  <xsl:choose>
  <xsl:when test="contains($list, ' ')">
    <xsl:call-template name="convert">
      <xsl:with-param name="file" select="substring-before($list, ' ')"/>
    </xsl:call-template>
    <xsl:call-template name="listchain">
      <xsl:with-param name="list" select="substring-after($list, ' ')"/>
    </xsl:call-template>
  </xsl:when>
  <xsl:otherwise>
    <xsl:call-template name="convert">
      <xsl:with-param name="file" select="$list"/>
    </xsl:call-template>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="convert">
  <xsl:param name="file"/>
  <xsl:message>reading <xsl:value-of select="$file"/></xsl:message>
  <xsl:for-each select="document($file)/cap:alert">
    <xsl:variable name="ninfos" select="count(cap:info)"/>
    <xsl:for-each select="cap:info">
      <xsl:variable name="infopos" select="position()"/>
      <xsl:variable name="capid0">
        <xsl:choose>
	<xsl:when test="cap:parameter[cap:valueName='UUID']">
	  <xsl:value-of
	  select="cap:parameter[cap:valueName='UUID']/cap:value"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="../cap:identifier"/>
	</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="capid">
        <xsl:choose>
        <xsl:when test="translate($capid0, '0123456789abcdef',
	  '################') = '########-####-####-####-############'">
	  <xsl:value-of select="concat('urn:uuid:', $capid0)"/>
	</xsl:when>
	<xsl:otherwise><xsl:value-of select="$capid0"/></xsl:otherwise>
	</xsl:choose>
      </xsl:variable>
      <xsl:variable name="id">
        <xsl:choose>
	<xsl:when test="$ninfos = 1 or cap:parameter[cap:valueName='UUID']">
	  <xsl:value-of select="$capid"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="concat($capid, '#', $infopos)"/>
	</xsl:otherwise>
	</xsl:choose>
      </xsl:variable>
      <xsl:message> id <xsl:value-of select="$id"/></xsl:message>
      <entry>
        <updated>
	  <xsl:choose>
	  <xsl:when test="function-available('date:add')">
	    <xsl:value-of select="date:add(../cap:sent,
	      concat('PT', 0.001 * $infopos, 'S')
	    )"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:value-of select="../cap:sent"/>
	  </xsl:otherwise>
	  </xsl:choose>
	</updated>
	<title><xsl:value-of select="cap:headline"/></title>
	<xsl:choose>
	<xsl:when test="contains(cap:description, '&#10;')">
	<summary type="xhtml">
	<div xmlns="http://www.w3.org/1999/xhtml">
	<pre>
	<xsl:value-of select="cap:description"/>
	</pre>
	</div>
	</summary>
	</xsl:when>
	<xsl:otherwise>
	<summary type="text"><xsl:value-of select="cap:description"/></summary>
	</xsl:otherwise>
	</xsl:choose>
	<id><xsl:value-of select="$id"/></id>
	<content type="application/cap+xml"
	>
	  <cap:alert>
	    <cap:identifier><xsl:value-of select="$id"/></cap:identifier>
	    <xsl:apply-templates select=
	    "../*[local-name() != 'info'][local-name() != 'identifier']"/>
	    <xsl:apply-templates select="."/>
	  </cap:alert>
	</content>
      </entry>
    </xsl:for-each>
  </xsl:for-each>
</xsl:template>

<xsl:template match="cap:*">
  <xsl:element name="cap:{local-name()}">
    <xsl:apply-templates select="*|text()|comment()"/>
  </xsl:element>
</xsl:template>

<xsl:template match="comment()">
  <xsl:copy-of select="."/>
</xsl:template>

</xsl:stylesheet>
